/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import org.easymock.classextension.EasyMock;
import org.easymock.classextension.IMocksControl;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.AvailabilityZoneInfo;
import org.jclouds.ec2.features.AvailabilityZoneAndRegionApi;
import org.jclouds.ec2.options.DescribeAvailabilityZonesOptions;
import org.jclouds.ec2.suppliers.DescribeAvailabilityZonesInRegion;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponseException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DescribeAvailabilityZonesInRegionTest {
    @Test
    public void testDescribeAvailabilityZonesInRegion_BestEffort() {
        IMocksControl control = EasyMock.createControl();
        EC2Api client = (EC2Api)control.createMock(EC2Api.class);
        AvailabilityZoneAndRegionApi regionClient = (AvailabilityZoneAndRegionApi)control.createMock(AvailabilityZoneAndRegionApi.class);
        AvailabilityZoneInfo info1 = (AvailabilityZoneInfo)control.createMock(AvailabilityZoneInfo.class);
        AvailabilityZoneInfo info2 = (AvailabilityZoneInfo)control.createMock(AvailabilityZoneInfo.class);
        HttpCommand command = (HttpCommand)control.createMock(HttpCommand.class);
        HttpResponseException exception = new HttpResponseException("Error: Unable to tunnel through proxy: ...", command, null);
        org.easymock.EasyMock.expect((Object)client.getAvailabilityZoneAndRegionApi()).andStubReturn((Object)Optional.of((Object)regionClient));
        org.easymock.EasyMock.expect((Object)regionClient.describeAvailabilityZonesInRegion("accessibleRegion1", new DescribeAvailabilityZonesOptions[0])).andReturn((Object)ImmutableSet.of((Object)info1));
        org.easymock.EasyMock.expect((Object)regionClient.describeAvailabilityZonesInRegion("inaccessibleRegion", new DescribeAvailabilityZonesOptions[0])).andThrow((Throwable)exception);
        org.easymock.EasyMock.expect((Object)regionClient.describeAvailabilityZonesInRegion("accessibleRegion2", new DescribeAvailabilityZonesOptions[0])).andReturn((Object)ImmutableSet.of((Object)info2));
        org.easymock.EasyMock.expect((Object)info1.getZone()).andStubReturn((Object)"zone1");
        org.easymock.EasyMock.expect((Object)info2.getZone()).andStubReturn((Object)"zone2");
        ImmutableSet regions = ImmutableSet.of((Object)"accessibleRegion1", (Object)"inaccessibleRegion", (Object)"accessibleRegion2");
        control.replay();
        ImmutableMap expectedResult = ImmutableMap.builder().put((Object)"accessibleRegion1", (Object)ImmutableSet.of((Object)"zone1")).put((Object)"accessibleRegion2", (Object)ImmutableSet.of((Object)"zone2")).build();
        DescribeAvailabilityZonesInRegion regionIdToZoneId = new DescribeAvailabilityZonesInRegion(client, Suppliers.ofInstance((Object)regions));
        Assert.assertEquals((Map)Maps.transformValues((Map)regionIdToZoneId.get(), (Function)Suppliers.supplierFunction()), (Map)expectedResult);
        control.verify();
    }

    @Test
    public void testDescribeAvailabilityZonesInRegion_RethrowIfNoneFound() {
        IMocksControl control = EasyMock.createControl();
        EC2Api client = (EC2Api)control.createMock(EC2Api.class);
        AvailabilityZoneAndRegionApi regionClient = (AvailabilityZoneAndRegionApi)control.createMock(AvailabilityZoneAndRegionApi.class);
        HttpCommand command = (HttpCommand)control.createMock(HttpCommand.class);
        HttpResponseException exception = new HttpResponseException("Error: Unable to tunnel through proxy: ...", command, null);
        org.easymock.EasyMock.expect((Object)client.getAvailabilityZoneAndRegionApi()).andStubReturn((Object)Optional.of((Object)regionClient));
        org.easymock.EasyMock.expect((Object)regionClient.describeAvailabilityZonesInRegion("inaccessibleRegion", new DescribeAvailabilityZonesOptions[0])).andThrow((Throwable)exception);
        ImmutableSet regions = ImmutableSet.of((Object)"inaccessibleRegion");
        control.replay();
        DescribeAvailabilityZonesInRegion regionIdToZoneId = new DescribeAvailabilityZonesInRegion(client, Suppliers.ofInstance((Object)regions));
        try {
            regionIdToZoneId.get();
            Assert.fail((String)"expected exception");
        }
        catch (HttpResponseException e) {
            Assert.assertEquals((Object)((Object)e), (Object)((Object)exception));
        }
        control.verify();
    }

    @Test
    public void testDescribeAvailabilityZonesInRegion_NoZones() {
        IMocksControl control = EasyMock.createControl();
        EC2Api client = (EC2Api)control.createMock(EC2Api.class);
        AvailabilityZoneAndRegionApi regionClient = (AvailabilityZoneAndRegionApi)control.createMock(AvailabilityZoneAndRegionApi.class);
        org.easymock.EasyMock.expect((Object)client.getAvailabilityZoneAndRegionApi()).andStubReturn((Object)Optional.of((Object)regionClient));
        org.easymock.EasyMock.expect((Object)regionClient.describeAvailabilityZonesInRegion("emptyRegion", new DescribeAvailabilityZonesOptions[0])).andReturn((Object)ImmutableSet.of());
        ImmutableSet regions = ImmutableSet.of((Object)"emptyRegion");
        control.replay();
        DescribeAvailabilityZonesInRegion regionIdToZoneId = new DescribeAvailabilityZonesInRegion(client, Suppliers.ofInstance((Object)regions));
        Assert.assertEquals((Map)regionIdToZoneId.get(), (Map)ImmutableMap.of());
        control.verify();
    }
}

