/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.ec2.domain.Tag;
import org.jclouds.ec2.util.Tags;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class TagsTest {
    Tag resourceTag1 = Tag.builder().resourceType("image").resourceId("1").key("key").value("value").build();
    Tag resourceTag2 = Tag.builder().resourceType("image").resourceId("1").key("foo").value("bar").build();
    Tag resource2Tag1 = Tag.builder().resourceType("instance").resourceId("2").key("absent").build();
    Tag resource2Tag2 = Tag.builder().resourceType("instance").resourceId("2").key("hello").value("world").build();

    public void testValueFunction() {
        Assert.assertEquals((String)((String)Tags.valueFunction().apply((Object)this.resourceTag1)), (String)"value");
    }

    public void testKeyFunction() {
        Assert.assertEquals((String)((String)Tags.keyFunction().apply((Object)this.resourceTag1)), (String)"key");
    }

    public void testResourceToTagsAsMap() {
        Assert.assertEquals((Map)Tags.resourceToTagsAsMap((Iterable)ImmutableSet.of((Object)this.resourceTag1, (Object)this.resourceTag2, (Object)this.resource2Tag1, (Object)this.resource2Tag2)), (Map)ImmutableMap.of((Object)"1", (Object)ImmutableMap.of((Object)"key", (Object)"value", (Object)"foo", (Object)"bar"), (Object)"2", (Object)ImmutableMap.of((Object)"absent", (Object)"", (Object)"hello", (Object)"world")));
    }
}

