/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import java.io.InputStream;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.xml.AttachmentHandler;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AttachmentHandlerTest")
public class AttachmentHandlerTest
extends BaseEC2HandlerTest {
    public void testApplyInputStream() {
        DateService dateService = (DateService)this.injector.getInstance(DateService.class);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/attach.xml");
        Attachment expected = new Attachment(this.defaultRegion, "vol-4d826724", "i-6058a509", "/dev/sdh", Attachment.Status.ATTACHING, dateService.iso8601DateParse("2008-05-07T11:51:50.000Z"));
        AttachmentHandler handler = (AttachmentHandler)this.injector.getInstance(AttachmentHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Attachment result = (Attachment)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Object)result, (Object)expected);
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

