/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.Map;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.xml.BlockDeviceMappingHandler;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BlockDeviceMappingHandlerTest")
public class BlockDeviceMappingHandlerTest
extends BaseHandlerTest {
    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/describe_image_attribute_blockDeviceMapping.xml");
        DateService dateService = (DateService)this.injector.getInstance(DateService.class);
        ImmutableMap expected = ImmutableMap.of((Object)"/dev/sda1", (Object)new BlockDevice("vol-d74b82be", Attachment.Status.ATTACHED, dateService.iso8601DateParse("2010-02-20T18:25:26.000Z"), true), (Object)"/dev/sdf", (Object)new BlockDevice("vol-another", Attachment.Status.DETACHED, dateService.iso8601DateParse("2010-02-20T19:26:26.000Z"), false));
        Map result = (Map)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(BlockDeviceMappingHandler.class)).parse(is);
        Assert.assertEquals((Map)result, (Map)expected);
    }
}

