/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import java.io.InputStream;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.BundleTask;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.ec2.xml.BundleTaskHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BundleTaskHandlerTest")
public class BundleTaskHandlerTest
extends BaseEC2HandlerTest {
    public void testBundleInstance() {
        DateService dateService = (DateService)this.injector.getInstance(DateService.class);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/bundle_instance.xml");
        BundleTask expected = new BundleTask(this.defaultRegion, "bun-c1a540a8", null, "i-12345678", 70, dateService.iso8601DateParse("2008-10-07T11:41:50.000Z"), "bundling", "my-bucket", "winami", dateService.iso8601DateParse("2008-10-07T11:51:50.000Z"));
        BundleTaskHandler handler = (BundleTaskHandler)this.injector.getInstance(BundleTaskHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        BundleTask result = (BundleTask)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Object)result, (Object)expected);
    }

    public void testCancleBundleTask() {
        DateService dateService = (DateService)this.injector.getInstance(DateService.class);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/cancel_bundle_task.xml");
        BundleTask expected = new BundleTask(this.defaultRegion, "bun-cla322b9", null, "i-12345678", 20, dateService.iso8601DateParse("2008-10-07T11:41:50.000Z"), "canceling", "my-bucket", "my-new-image", dateService.iso8601DateParse("2008-10-07T11:51:50.000Z"));
        BundleTaskHandler handler = (BundleTaskHandler)this.injector.getInstance(BundleTaskHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        BundleTask result = (BundleTask)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Object)result, (Object)expected);
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

