/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import java.io.InputStream;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.xml.BooleanValueHandler;
import org.jclouds.ec2.xml.InstanceInitiatedShutdownBehaviorHandler;
import org.jclouds.ec2.xml.InstanceTypeHandler;
import org.jclouds.ec2.xml.StringValueHandler;
import org.jclouds.ec2.xml.UnencodeStringValueHandler;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DescribeInstanceAttributeTest")
public class DescribeInstanceAttributeTest
extends BaseHandlerTest {
    public void testInstanceInitiatedShutdownBehaviorHandler() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/instanceInitiatedShutdownBehavior.xml");
        InstanceInitiatedShutdownBehaviorHandler handler = (InstanceInitiatedShutdownBehaviorHandler)this.injector.getInstance(InstanceInitiatedShutdownBehaviorHandler.class);
        Volume.InstanceInitiatedShutdownBehavior result = (Volume.InstanceInitiatedShutdownBehavior)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Object)result, (Object)Volume.InstanceInitiatedShutdownBehavior.STOP);
    }

    public void testInstanceTypeHandler() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/instanceType.xml");
        InstanceTypeHandler handler = (InstanceTypeHandler)this.injector.getInstance(InstanceTypeHandler.class);
        String result = (String)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result, (String)"m1.small");
    }

    public void testBooleanValueHandler() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/disableApiTermination.xml");
        BooleanValueHandler handler = (BooleanValueHandler)this.injector.getInstance(BooleanValueHandler.class);
        Boolean result = (Boolean)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        assert (!result.booleanValue());
    }

    public void testStringValueHandler() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/ramdisk.xml");
        StringValueHandler handler = (StringValueHandler)this.injector.getInstance(StringValueHandler.class);
        String result = (String)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result, (String)"ari-a51cf9cc");
    }

    public void testUnencodeStringValueHandler() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/userData.xml");
        UnencodeStringValueHandler handler = (UnencodeStringValueHandler)this.injector.getInstance(UnencodeStringValueHandler.class);
        String result = (String)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result, (String)"#!/bin/bash\n");
    }
}

