/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Snapshot;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.ec2.xml.DescribeSnapshotsResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DescribeSnapshotsResponseHandlerTest")
public class DescribeSnapshotsResponseHandlerTest
extends BaseEC2HandlerTest {
    public void testApplyInputStream() {
        DateService dateService = (DateService)this.injector.getInstance(DateService.class);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/describe_snapshots.xml");
        LinkedHashSet expected = Sets.newLinkedHashSet();
        expected.add(new Snapshot(this.defaultRegion, "snap-78a54011", "vol-4d826724", 10, Snapshot.Status.PENDING, dateService.iso8601DateParse("2008-05-07T12:51:50.000Z"), 80, "218213537122", "Daily Backup", null));
        DescribeSnapshotsResponseHandler handler = (DescribeSnapshotsResponseHandler)this.injector.getInstance(DescribeSnapshotsResponseHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Set result = (Set)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((Set)result, (Set)expected);
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

