/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.ec2.xml.RunInstancesResponseHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RunInstancesResponseHandlerTest")
public class RunInstancesResponseHandlerTest
extends BaseEC2HandlerTest {
    private DateService dateService;

    @Override
    @BeforeTest
    protected void setUpInjector() {
        super.setUpInjector();
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
        assert (this.dateService != null);
    }

    public void testEC2() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/run_instances.xml");
        Reservation expected = new Reservation(this.defaultRegion, (Iterable)ImmutableSet.of((Object)"default"), (Iterable)ImmutableSet.of((Object)RunningInstance.builder().region(this.defaultRegion).groupName("default").amiLaunchIndex("0").imageId("ami-60a54009").instanceId("i-2ba64342").instanceState(InstanceState.PENDING).rawState("pending").instanceType("m1.small").keyName("example-key-name").launchTime(this.dateService.iso8601DateParse("2007-08-07T11:51:50.000Z")).availabilityZone("us-east-1b").build(), (Object)RunningInstance.builder().region(this.defaultRegion).groupName("default").amiLaunchIndex("1").imageId("ami-60a54009").instanceId("i-2bc64242").instanceState(InstanceState.PENDING).rawState("pending").instanceType("m1.small").keyName("example-key-name").launchTime(this.dateService.iso8601DateParse("2007-08-07T11:51:50.000Z")).availabilityZone("us-east-1b").build(), (Object)RunningInstance.builder().region(this.defaultRegion).groupName("default").amiLaunchIndex("2").imageId("ami-60a54009").instanceId("i-2be64332").instanceState(InstanceState.PENDING).rawState("pending").instanceType("m1.small").keyName("example-key-name").launchTime(this.dateService.iso8601DateParse("2007-08-07T11:51:50.000Z")).availabilityZone("us-east-1b").build()), "AIDADH4IGTRXXKCD", null, "r-47a5402e");
        RunInstancesResponseHandler handler = (RunInstancesResponseHandler)this.injector.getInstance(RunInstancesResponseHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Reservation result = (Reservation)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public void testCloudBridge() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/run_instances_cloudbridge.xml");
        Reservation expected = new Reservation(this.defaultRegion, (Iterable)ImmutableSet.of((Object)"jclouds#greenqloud-computeblock"), (Iterable)ImmutableSet.of((Object)RunningInstance.builder().region(this.defaultRegion).groupName("jclouds#greenqloud-computeblock").amiLaunchIndex("0").imageId("qmi-9ac92558").instanceId("i-01b0dac3").instanceState(InstanceState.PENDING).rawState("pending").instanceType("m1.small").keyName("jclouds#greenqloud-computeblock#35").launchTime(this.dateService.iso8601DateParse("2012-06-15T19:06:35.000+00:00")).rootDeviceType(RootDeviceType.EBS).availabilityZone("is-1a").build()), "56eeacd9-c790-45c3-85f3-e4380b55e1d8<", null, "r-f847a6ca");
        RunInstancesResponseHandler handler = (RunInstancesResponseHandler)this.injector.getInstance(RunInstancesResponseHandler.class);
        this.addDefaultRegionToHandler((ParseSax.HandlerWithResult<?>)handler);
        Reservation result = (Reservation)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    private void addDefaultRegionToHandler(ParseSax.HandlerWithResult<?> handler) {
        handler.setContext((HttpRequest)this.request);
    }
}

