/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.internal.BaseComputeService;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.features.FirewallApi;
import org.jclouds.http.HttpResponse;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;
import org.jclouds.util.Predicates2;

public class GoogleComputeEngineService
extends BaseComputeService {
    private final Function<Set<? extends NodeMetadata>, Set<String>> findOrphanedGroups;
    private final GroupNamingConvention.Factory namingConvention;
    private final GoogleComputeEngineApi api;
    private final Supplier<String> project;
    private final Predicate<AtomicReference<Operation>> operationDonePredicate;
    private final long operationCompleteCheckInterval;
    private final long operationCompleteCheckTimeout;

    @Inject
    protected GoogleComputeEngineService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwareProfiles, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetImageStrategy getImageStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy resumeNodeStrategy, SuspendNodeStrategy suspendNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, @Named(value="DEFAULT") Provider<TemplateOptions> templateOptionsProvider, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<AtomicReference<NodeMetadata>> nodeTerminated, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<AtomicReference<NodeMetadata>> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, InitAdminAccess initAdminAccess, RunScriptOnNode.Factory runScriptOnNodeFactory, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, Optional<ImageExtension> imageExtension, Optional<SecurityGroupExtension> securityGroupExtension, Function<Set<? extends NodeMetadata>, Set<String>> findOrphanedGroups, GroupNamingConvention.Factory namingConvention, GoogleComputeEngineApi api, @UserProject Supplier<String> project, @Named(value="global") Predicate<AtomicReference<Operation>> operationDonePredicate, @Named(value="jclouds.google-compute-engine.operation-complete-interval") Long operationCompleteCheckInterval, @Named(value="jclouds.google-compute-engine.operation-complete-timeout") Long operationCompleteCheckTimeout) {
        super(context, credentialStore, images, hardwareProfiles, locations, listNodesStrategy, getImageStrategy, getNodeMetadataStrategy, runNodesAndAddToSetStrategy, rebootNodeStrategy, destroyNodeStrategy, resumeNodeStrategy, suspendNodeStrategy, templateBuilderProvider, templateOptionsProvider, nodeRunning, nodeTerminated, nodeSuspended, initScriptRunnerFactory, initAdminAccess, runScriptOnNodeFactory, persistNodeCredentials, timeouts, userExecutor, imageExtension, securityGroupExtension);
        this.findOrphanedGroups = (Function)Preconditions.checkNotNull(findOrphanedGroups, (Object)"find orphaned groups function");
        this.namingConvention = (GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"naming convention factory");
        this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"google compute api");
        this.project = (Supplier)Preconditions.checkNotNull(project, (Object)"user project name");
        this.operationDonePredicate = (Predicate)Preconditions.checkNotNull(operationDonePredicate, (Object)"operation completed predicate");
        this.operationCompleteCheckInterval = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckInterval, (Object)"operation completed check interval");
        this.operationCompleteCheckTimeout = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckTimeout, (Object)"operation completed check timeout");
    }

    protected synchronized void cleanUpIncidentalResourcesOfDeadNodes(Set<? extends NodeMetadata> deadNodes) {
        Set orphanedGroups = (Set)this.findOrphanedGroups.apply(deadNodes);
        for (String orphanedGroup : orphanedGroups) {
            this.cleanUpNetworksAndFirewallsForGroup(orphanedGroup);
        }
    }

    protected void cleanUpNetworksAndFirewallsForGroup(String groupName) {
        String resourceName = this.namingConvention.create().sharedNameForGroup(groupName);
        final Network network = this.api.getNetworkApiForProject((String)this.project.get()).get(resourceName);
        FirewallApi firewallApi = this.api.getFirewallApiForProject((String)this.project.get());
        Predicate<Firewall> firewallBelongsToNetwork = new Predicate<Firewall>(){

            public boolean apply(Firewall input) {
                return input != null && input.getNetwork().equals(network.getSelfLink());
            }
        };
        HashSet operations = Sets.newHashSet();
        for (Firewall firewall : firewallApi.list().concat().filter((Predicate)firewallBelongsToNetwork)) {
            operations.add(new AtomicReference<Operation>(firewallApi.delete(firewall.getName())));
        }
        for (AtomicReference operation : operations) {
            Predicates2.retry(this.operationDonePredicate, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)operation);
            if (!((Operation)operation.get()).getHttpError().isPresent()) continue;
            HttpResponse response = (HttpResponse)((Operation)operation.get()).getHttpError().get();
            this.logger.warn("delete orphaned firewall %s failed. Http Error Code: %d HttpError: %s", new Object[]{((Operation)operation.get()).getTargetId(), response.getStatusCode(), response.getMessage()});
        }
        AtomicReference operation = Atomics.newReference((Object)this.api.getNetworkApiForProject((String)this.project.get()).delete(resourceName));
        Predicates2.retry(this.operationDonePredicate, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)operation);
        if (((Operation)operation.get()).getHttpError().isPresent()) {
            HttpResponse response = (HttpResponse)((Operation)operation.get()).getHttpError().get();
            this.logger.warn("delete orphaned network failed. Http Error Code: " + response.getStatusCode() + " HttpError: " + response.getMessage(), new Object[0]);
        }
    }

    public GoogleComputeEngineTemplateOptions templateOptions() {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.templateOptions()));
    }
}

