/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.loaders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.internal.NetworkAndAddressRange;
import org.jclouds.logging.Logger;

public class FindNetworkOrCreate
extends CacheLoader<NetworkAndAddressRange, Network> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final GoogleComputeEngineApi api;
    protected final Function<NetworkAndAddressRange, Network> networkCreator;
    protected final Supplier<String> userProject;

    @Inject
    public FindNetworkOrCreate(GoogleComputeEngineApi api, Function<NetworkAndAddressRange, Network> networkCreator, @UserProject Supplier<String> userProject) {
        this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.networkCreator = (Function)Preconditions.checkNotNull(networkCreator, (Object)"networkCreator");
        this.userProject = (Supplier)Preconditions.checkNotNull(userProject, (Object)"userProject");
    }

    public Network load(NetworkAndAddressRange in) {
        Network network = this.api.getNetworkApiForProject((String)this.userProject.get()).get(in.getName());
        if (network != null) {
            return network;
        }
        return (Network)this.networkCreator.apply((Object)in);
    }
}

