/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ssh.internal.RsaSshKeyPairGenerator;

@Singleton
public class PopulateDefaultLoginCredentialsForImageStrategy
implements org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy {
    private final TemplateBuilderSpec templateBuilder;
    private final RsaSshKeyPairGenerator keyPairGenerator;
    private String compoundKey;

    @Inject
    PopulateDefaultLoginCredentialsForImageStrategy(@Named(value="jclouds.template") String templateSpec, RsaSshKeyPairGenerator keyPairGenerator) throws NoSuchAlgorithmException {
        this.templateBuilder = TemplateBuilderSpec.parse((String)((String)Preconditions.checkNotNull((Object)templateSpec, (Object)"template builder spec")));
        Preconditions.checkNotNull((Object)this.templateBuilder.getLoginUser(), (Object)"template builder spec must provide a loginUser");
        this.keyPairGenerator = (RsaSshKeyPairGenerator)Preconditions.checkNotNull((Object)keyPairGenerator, (Object)"keypair generator");
    }

    @PostConstruct
    private void generateKeys() {
        Map keys = this.keyPairGenerator.get();
        this.compoundKey = String.format("%s:%s", Preconditions.checkNotNull(keys.get("public"), (Object)"public key cannot be null"), Preconditions.checkNotNull(keys.get("private"), (Object)"private key cannot be null"));
    }

    public LoginCredentials apply(Object image) {
        return LoginCredentials.builder().authenticateSudo(this.templateBuilder.getAuthenticateSudo() != null ? this.templateBuilder.getAuthenticateSudo() : false).privateKey(this.compoundKey).user(this.templateBuilder.getLoginUser()).build();
    }
}

