/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;

public class Metadata {
    @Nullable
    private final String fingerprint;
    private final Map<String, String> items;

    @ConstructorProperties(value={"fingerprint", "items"})
    public Metadata(@Nullable String fingerprint, @Nullable Map<String, String> items) {
        this.fingerprint = fingerprint;
        this.items = items == null ? ImmutableMap.of() : items;
    }

    public Map<String, String> getItems() {
        return this.items;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fingerprint, this.items});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Metadata that = (Metadata)Metadata.class.cast(obj);
        return Objects.equal(this.items, that.items) && Objects.equal((Object)this.fingerprint, (Object)that.fingerprint);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("items", this.items).add("fingerprint", (Object)this.fingerprint);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.string().toString();
    }

    public static final class Builder {
        private ImmutableMap.Builder<String, String> items = ImmutableMap.builder();
        private String fingerprint;

        public Builder addItem(String key, String value) {
            this.items.put((Object)key, (Object)value);
            return this;
        }

        public Builder items(Map<String, String> items) {
            this.items.putAll(items);
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Metadata build() {
            return new Metadata(this.fingerprint, (Map<String, String>)this.items.build());
        }

        public Builder fromMetadata(Metadata in) {
            return this.fingerprint(in.getFingerprint()).items(in.getItems());
        }
    }
}

