/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Date;
import java.util.Set;
import org.jclouds.googlecomputeengine.domain.Metadata;
import org.jclouds.googlecomputeengine.domain.Quota;
import org.jclouds.googlecomputeengine.domain.Resource;
import org.jclouds.javax.annotation.Nullable;

@Beta
public class Project
extends Resource {
    private final Metadata commonInstanceMetadata;
    private final Set<Quota> quotas;
    private final Set<String> externalIpAddresses;

    protected Project(String id, Date creationTimestamp, URI selfLink, String name, String description, Metadata commonInstanceMetadata, Set<Quota> quotas, Set<String> externalIpAddresses) {
        super(Resource.Kind.PROJECT, id, creationTimestamp, selfLink, name, description);
        this.commonInstanceMetadata = (Metadata)Preconditions.checkNotNull((Object)commonInstanceMetadata, (Object)"commonInstanceMetadata");
        this.quotas = quotas == null ? ImmutableSet.of() : ImmutableSet.copyOf(quotas);
        this.externalIpAddresses = externalIpAddresses == null ? ImmutableSet.of() : ImmutableSet.copyOf(externalIpAddresses);
    }

    public Metadata getCommonInstanceMetadata() {
        return this.commonInstanceMetadata;
    }

    public Set<Quota> getQuotas() {
        return this.quotas;
    }

    @Nullable
    public Set<String> getExternalIpAddresses() {
        return this.externalIpAddresses;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("commonInstanceMetadata", (Object)this.commonInstanceMetadata).add("quotas", this.quotas).add("externalIpAddresses", this.externalIpAddresses);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromProject(this);
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private Metadata commonInstanceMetadata;
        private ImmutableSet.Builder<Quota> quotas = ImmutableSet.builder();
        private ImmutableSet.Builder<String> externalIpAddresses = ImmutableSet.builder();

        public Builder commonInstanceMetadata(Metadata commonInstanceMetadata) {
            this.commonInstanceMetadata = commonInstanceMetadata;
            return this;
        }

        public Builder addQuota(String metric, double usage, double limit) {
            this.quotas.add((Object)Quota.builder().metric(metric).usage(usage).limit(limit).build());
            return this;
        }

        public Builder quotas(Set<Quota> quotas) {
            this.quotas.addAll((Iterable)Preconditions.checkNotNull(quotas));
            return this;
        }

        public Builder addExternalIpAddress(String externalIpAddress) {
            this.externalIpAddresses.add(Preconditions.checkNotNull((Object)externalIpAddress, (Object)"externalIpAddress"));
            return this;
        }

        public Builder externalIpAddresses(Set<String> externalIpAddresses) {
            this.externalIpAddresses.addAll((Iterable)Preconditions.checkNotNull(externalIpAddresses, (Object)"externalIpAddresses"));
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Project build() {
            return new Project(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.commonInstanceMetadata, (Set<Quota>)this.quotas.build(), (Set<String>)this.externalIpAddresses.build());
        }

        public Builder fromProject(Project in) {
            return ((Builder)super.fromResource(in)).commonInstanceMetadata(in.getCommonInstanceMetadata()).quotas(in.getQuotas()).externalIpAddresses(in.getExternalIpAddresses());
        }
    }
}

