/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

@Beta
public class Quota {
    private String metric;
    private double usage;
    private double limit;

    @ConstructorProperties(value={"metric", "usage", "limit"})
    public Quota(String metric, Double usage, Double limit) {
        this.metric = metric != null ? metric : "undefined";
        this.usage = (Double)Preconditions.checkNotNull((Object)usage, (Object)"usage");
        this.limit = (Double)Preconditions.checkNotNull((Object)limit, (Object)"limit");
    }

    public String getMetric() {
        return this.metric;
    }

    public Double getUsage() {
        return this.usage;
    }

    public Double getLimit() {
        return this.limit;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.metric});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Quota that = (Quota)Quota.class.cast(obj);
        return Objects.equal((Object)this.metric, (Object)that.metric);
    }

    public Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("metric", (Object)this.metric).add("usage", this.usage).add("limit", this.limit);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Quota.builder().fromQuota(this);
    }

    public static class Builder {
        private String metric;
        private Double usage;
        private Double limit;

        public Builder metric(String metric) {
            this.metric = (String)Preconditions.checkNotNull((Object)metric, (Object)"metric");
            return this;
        }

        public Builder usage(Double usage) {
            this.usage = usage;
            return this;
        }

        public Builder limit(Double limit) {
            this.limit = limit;
            return this;
        }

        public Quota build() {
            return new Quota(this.metric, this.usage, this.limit);
        }

        public Builder fromQuota(Quota quota) {
            return new Builder().metric(quota.getMetric()).usage(quota.getUsage()).limit(quota.getLimit());
        }
    }
}

