/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import org.jclouds.googlecomputeengine.domain.AbstractDisk;
import org.jclouds.googlecomputeengine.domain.Resource;

@Beta
public final class Snapshot
extends AbstractDisk {
    private final Optional<URI> sourceDisk;
    private final String sourceDiskId;

    @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "diskSizeGb", "status", "sourceDisk", "sourceDiskId"})
    private Snapshot(String id, Date creationTimestamp, URI selfLink, String name, String description, Integer sizeGb, String status, URI sourceDisk, String sourceDiskId) {
        super(Resource.Kind.SNAPSHOT, id, creationTimestamp, selfLink, name, description, sizeGb, status);
        this.sourceDisk = Optional.fromNullable((Object)sourceDisk);
        this.sourceDiskId = (String)Preconditions.checkNotNull((Object)sourceDiskId, (String)"sourceDiskId of %s", (Object[])new Object[]{name});
    }

    public Optional<URI> getSourceDisk() {
        return this.sourceDisk;
    }

    public String getSourceDiskId() {
        return this.sourceDiskId;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().omitNullValues().add("sourceDisk", this.sourceDisk.orNull()).add("sourceDiskId", (Object)this.sourceDiskId);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return new Builder().fromSnapshot(this);
    }

    public static final class Builder
    extends AbstractDisk.Builder<Builder> {
        private URI sourceDisk;
        private String sourceDiskId;

        public Builder sourceDisk(URI sourceDisk) {
            this.sourceDisk = sourceDisk;
            return this;
        }

        public Builder sourceDiskId(String sourceDiskId) {
            this.sourceDiskId = sourceDiskId;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Snapshot build() {
            return new Snapshot(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.sizeGb, this.status, this.sourceDisk, this.sourceDiskId);
        }

        public Builder fromSnapshot(Snapshot in) {
            return ((Builder)super.fromAbstractDisk(in)).sourceDisk((URI)in.getSourceDisk().orNull()).sourceDiskId(in.getSourceDiskId());
        }
    }
}

