/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import java.util.Set;
import org.jclouds.googlecomputeengine.domain.Resource;
import org.jclouds.javax.annotation.Nullable;

@Beta
public final class Zone
extends Resource {
    private final Status status;
    private final Set<MaintenanceWindow> maintenanceWindows;
    private final Set<String> availableMachineTypes;

    @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "status", "maintenanceWindows", "availableMachineTypes"})
    private Zone(String id, Date creationTimestamp, URI selfLink, String name, String description, Status status, Set<MaintenanceWindow> maintenanceWindows, Set<String> availableMachineTypes) {
        super(Resource.Kind.ZONE, id, creationTimestamp, selfLink, name, description);
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (String)"status of %name", (Object[])new Object[]{name}));
        this.maintenanceWindows = maintenanceWindows == null ? ImmutableSet.of() : ImmutableSet.copyOf(maintenanceWindows);
        this.availableMachineTypes = availableMachineTypes == null ? ImmutableSet.of() : ImmutableSet.copyOf(availableMachineTypes);
    }

    public Status getStatus() {
        return this.status;
    }

    public Set<MaintenanceWindow> getMaintenanceWindows() {
        return this.maintenanceWindows;
    }

    @Nullable
    public Set<String> getAvailableMachineTypes() {
        return this.availableMachineTypes;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("status", (Object)this.status).add("maintenanceWindows", this.maintenanceWindows).add("availableMachineTypes", this.availableMachineTypes);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromZone(this);
    }

    public static final class MaintenanceWindow {
        private final String name;
        private final Optional<String> description;
        private final Date beginTime;
        private final Date endTime;

        @ConstructorProperties(value={"name", "description", "beginTime", "endTime"})
        private MaintenanceWindow(String name, String description, Date beginTime, Date endTime) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.description = Optional.fromNullable((Object)description);
            this.beginTime = (Date)Preconditions.checkNotNull((Object)beginTime, (String)"beginTime of %name", (Object[])new Object[]{name});
            this.endTime = (Date)Preconditions.checkNotNull((Object)endTime, (String)"endTime of %name", (Object[])new Object[]{name});
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getDescription() {
            return this.description;
        }

        public Date getBeginTime() {
            return this.beginTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.description, this.beginTime, this.endTime});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MaintenanceWindow that = (MaintenanceWindow)MaintenanceWindow.class.cast(obj);
            return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.beginTime, (Object)that.beginTime) && Objects.equal((Object)this.endTime, (Object)that.endTime);
        }

        protected Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("description", this.description.orNull()).add("beginTime", (Object)this.beginTime).add("endTime", (Object)this.endTime);
        }

        public String toString() {
            return this.string().toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return MaintenanceWindow.builder().fromZoneMaintenanceWindow(this);
        }

        public static final class Builder {
            private String name;
            private String description;
            private Date beginTime;
            private Date endTime;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder beginTime(Date beginTime) {
                this.beginTime = beginTime;
                return this;
            }

            public Builder endTime(Date endTime) {
                this.endTime = endTime;
                return this;
            }

            public MaintenanceWindow build() {
                return new MaintenanceWindow(this.name, this.description, this.beginTime, this.endTime);
            }

            public Builder fromZoneMaintenanceWindow(MaintenanceWindow in) {
                return new Builder().name(in.getName()).description((String)in.getDescription().orNull()).beginTime(in.getBeginTime()).endTime(in.getEndTime());
            }
        }
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private Status status;
        private ImmutableSet.Builder<MaintenanceWindow> maintenanceWindows = ImmutableSet.builder();
        private ImmutableSet.Builder<String> availableMachineTypes = ImmutableSet.builder();

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder addMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindows.add(Preconditions.checkNotNull((Object)maintenanceWindow, (Object)"maintenanceWindow"));
            return this;
        }

        public Builder maintenanceWindows(Set<MaintenanceWindow> maintenanceWindows) {
            this.maintenanceWindows.addAll((Iterable)Preconditions.checkNotNull(maintenanceWindows, (Object)"maintenanceWindows"));
            return this;
        }

        public Builder addAvailableMachineType(String availableMachineType) {
            this.availableMachineTypes.add(Preconditions.checkNotNull((Object)availableMachineType, (Object)"availableMachineType"));
            return this;
        }

        public Builder availableMachineTypes(Set<String> availableMachineTypes) {
            this.availableMachineTypes.addAll((Iterable)Preconditions.checkNotNull(availableMachineTypes, (Object)"availableMachineTypes"));
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Zone build() {
            return new Zone(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.status, (Set)this.maintenanceWindows.build(), (Set)this.availableMachineTypes.build());
        }

        public Builder fromZone(Zone in) {
            return ((Builder)super.fromResource(in)).status(in.getStatus()).maintenanceWindows(in.getMaintenanceWindows()).availableMachineTypes(in.getAvailableMachineTypes());
        }
    }

    public static enum Status {
        UP,
        DOWN;

    }
}

