/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.functions.internal.ParseGlobalOperations;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthAuthenticationFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthAuthenticationFilter.class})
public interface GlobalOperationApi {
    @Named(value="GlobalOperations:get")
    @GET
    @Path(value="/global/operations/{operation}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Operation get(@PathParam(value="operation") String var1);

    @Named(value="GlobalOperations:delete")
    @DELETE
    @Path(value="/global/operations/{operation}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public void delete(@PathParam(value="operation") String var1);

    @Named(value="GlobalOperations:list")
    @GET
    @Path(value="/global/operations")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseGlobalOperations.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Operation> listFirstPage();

    @Named(value="GlobalOperations:list")
    @GET
    @Path(value="/global/operations")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseGlobalOperations.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Operation> listAtMarker(@QueryParam(value="pageToken") @Nullable String var1);

    @Named(value="GlobalOperations:list")
    @GET
    @Path(value="/global/operations")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseGlobalOperations.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Operation> listAtMarker(@QueryParam(value="pageToken") @Nullable String var1, ListOptions var2);

    @Named(value="GlobalOperations:list")
    @GET
    @Path(value="/global/operations")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseGlobalOperations.class)
    @Transform(value=ParseGlobalOperations.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Operation> list();

    @Named(value="GlobalOperations:list")
    @GET
    @Path(value="/global/operations")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseGlobalOperations.class)
    @Transform(value=ParseGlobalOperations.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Operation> list(ListOptions var1);
}

