/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.functions.internal.ParseZoneOperations;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthAuthenticationFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthAuthenticationFilter.class})
public interface ZoneOperationApi {
    @Named(value="ZoneOperations:get")
    @GET
    @Path(value="/zones/{zone}/operations/{operation}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Operation getInZone(@PathParam(value="zone") String var1, @PathParam(value="operation") String var2);

    @Named(value="ZoneOperations:delete")
    @DELETE
    @Path(value="/zones/{zone}/operations/{operation}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public void deleteInZone(@PathParam(value="zone") String var1, @PathParam(value="operation") String var2);

    @Named(value="ZoneOperations:list")
    @GET
    @Path(value="/zones/{zone}/operations")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseZoneOperations.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Operation> listFirstPageInZone(@PathParam(value="zone") String var1);

    @Named(value="ZoneOperations:list")
    @GET
    @Path(value="/zones/{zone}/operations")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseZoneOperations.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Operation> listAtMarkerInZone(@PathParam(value="zone") String var1, @QueryParam(value="pageToken") @Nullable String var2);

    @Named(value="ZoneOperations:list")
    @GET
    @Path(value="/zones/{zone}/operations")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseZoneOperations.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Operation> listAtMarkerInZone(@PathParam(value="zone") String var1, @QueryParam(value="pageToken") @Nullable String var2, ListOptions var3);

    @Named(value="ZoneOperations:list")
    @GET
    @Path(value="/zones/{zone}/operations")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseZoneOperations.class)
    @Transform(value=ParseZoneOperations.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Operation> listInZone(@PathParam(value="zone") String var1);

    @Named(value="ZoneOperations:list")
    @GET
    @Path(value="/zones/{zone}/operations")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseZoneOperations.class)
    @Transform(value=ParseZoneOperations.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Operation> listInZone(@PathParam(value="zone") String var1, ListOptions var2);
}

