/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.functions.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Address;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.functions.internal.BaseWithRegionToPagedIterable;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;

@Singleton
public class ParseAddresses
extends ParseJson<ListPage<Address>> {
    @Inject
    public ParseAddresses(Json json) {
        super(json, (TypeLiteral)new TypeLiteral<ListPage<Address>>(){});
    }

    public static class ToPagedIterable
    extends BaseWithRegionToPagedIterable<Address, ToPagedIterable> {
        private final GoogleComputeEngineApi api;

        @Inject
        protected ToPagedIterable(GoogleComputeEngineApi api) {
            this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        @Override
        protected Function<Object, IterableWithMarker<Address>> fetchNextPage(final String projectName, final String regionName, final ListOptions options) {
            return new Function<Object, IterableWithMarker<Address>>(){

                public IterableWithMarker<Address> apply(Object input) {
                    return ToPagedIterable.this.api.getAddressApiForProject(projectName).listAtMarkerInRegion(regionName, input.toString(), options);
                }
            };
        }
    }
}

