/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.functions.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Disk;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.functions.internal.BaseWithZoneToPagedIterable;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;

@Singleton
public class ParseDisks
extends ParseJson<ListPage<Disk>> {
    @Inject
    public ParseDisks(Json json) {
        super(json, (TypeLiteral)new TypeLiteral<ListPage<Disk>>(){});
    }

    public static class ToPagedIterable
    extends BaseWithZoneToPagedIterable<Disk, ToPagedIterable> {
        private final GoogleComputeEngineApi api;

        @Inject
        protected ToPagedIterable(GoogleComputeEngineApi api) {
            this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        @Override
        protected Function<Object, IterableWithMarker<Disk>> fetchNextPage(final String projectName, final String zoneName, final ListOptions options) {
            return new Function<Object, IterableWithMarker<Disk>>(){

                public IterableWithMarker<Disk> apply(Object input) {
                    return ToPagedIterable.this.api.getDiskApiForProject(projectName).listAtMarkerInZone(zoneName, input.toString(), options);
                }
            };
        }
    }
}

