/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.handlers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.googlecomputeengine.domain.InstanceTemplate;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class InstanceBinder
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    @Inject
    @Named(value="machineTypeToURI")
    Function<String, URI> machineTypesToURI;

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        InstanceTemplate template = (InstanceTemplate)Preconditions.checkNotNull((Object)postParams.get("template"), (Object)"template");
        template.name(Preconditions.checkNotNull((Object)postParams.get("name"), (Object)"name").toString());
        if (template.getMachineTypeName() != null) {
            template.machineType((URI)this.machineTypesToURI.apply((Object)template.getMachineTypeName()));
        }
        template.machineType((String)null);
        return this.bindToRequest(request, template);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }
}

