/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jclouds.oauth.v2.config.CredentialType;
import org.jclouds.oauth.v2.domain.ClaimSet;
import org.jclouds.oauth.v2.domain.Header;
import org.jclouds.oauth.v2.domain.OAuthCredentials;
import org.jclouds.oauth.v2.domain.Token;
import org.jclouds.oauth.v2.domain.TokenRequest;
import org.jclouds.oauth.v2.filters.BearerTokenAuthenticator;
import org.jclouds.oauth.v2.filters.OAuthAuthenticationFilter;
import org.jclouds.oauth.v2.filters.OAuthAuthenticator;
import org.jclouds.oauth.v2.functions.BuildTokenRequest;
import org.jclouds.oauth.v2.functions.FetchToken;
import org.jclouds.oauth.v2.functions.OAuthCredentialsSupplier;
import org.jclouds.oauth.v2.functions.SignOrProduceMacForToken;
import org.jclouds.oauth.v2.json.ClaimSetTypeAdapter;
import org.jclouds.oauth.v2.json.HeaderTypeAdapter;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class OAuthModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Function<byte[], byte[]>>(){}).to(SignOrProduceMacForToken.class);
        this.bind((TypeLiteral)new TypeLiteral<Map<Type, Object>>(){}).toInstance((Object)ImmutableMap.of(Header.class, (Object)((Object)new HeaderTypeAdapter()), ClaimSet.class, (Object)((Object)new ClaimSetTypeAdapter())));
        this.bind(CredentialType.class).toProvider(CredentialTypeFromPropertyOrDefault.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<OAuthCredentials>>(){}).to(OAuthCredentialsSupplier.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<GeneratedHttpRequest, TokenRequest>>(){}).to(BuildTokenRequest.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<TokenRequest, Token>>(){}).to(FetchToken.class);
    }

    @Provides
    @Singleton
    public LoadingCache<TokenRequest, Token> provideAccessCache(Function<TokenRequest, Token> getAccess, @Named(value="jclouds.session-interval") long sessionIntervalInSeconds) {
        sessionIntervalInSeconds = sessionIntervalInSeconds > 30L ? sessionIntervalInSeconds - 30L : sessionIntervalInSeconds;
        return CacheBuilder.newBuilder().expireAfterWrite(sessionIntervalInSeconds, TimeUnit.SECONDS).build(CacheLoader.from(getAccess));
    }

    @Provides
    @Singleton
    protected OAuthAuthenticationFilter authenticationFilterForCredentialType(CredentialType credentialType, OAuthAuthenticator serviceAccountAuth, BearerTokenAuthenticator bearerTokenAuth) {
        switch (credentialType) {
            case SERVICE_ACCOUNT_CREDENTIALS: {
                return serviceAccountAuth;
            }
            case BEARER_TOKEN_CREDENTIALS: {
                return bearerTokenAuth;
            }
        }
        throw new IllegalArgumentException("Unsupported credential type: " + (Object)((Object)credentialType));
    }

    @Singleton
    public static class CredentialTypeFromPropertyOrDefault
    implements Provider<CredentialType> {
        @Inject(optional=true)
        @Named(value="jclouds.oauth.credential-type")
        String credentialType = CredentialType.SERVICE_ACCOUNT_CREDENTIALS.toString();

        public CredentialType get() {
            return CredentialType.fromValue(this.credentialType);
        }
    }
}

