/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ClaimSet
extends ForwardingMap<String, String> {
    private final Map<String, String> claims;
    private final long emissionTime;
    private final long expirationTime;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ClaimSet.builder().fromClaimSet(this);
    }

    private ClaimSet(Map<String, String> claims, long emissionTime, long expirationTime) {
        this.claims = claims;
        this.emissionTime = emissionTime;
        this.expirationTime = expirationTime;
    }

    public long getEmissionTime() {
        return this.emissionTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    protected Map<String, String> delegate() {
        return this.claims;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.claims});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ClaimSet other = (ClaimSet)((Object)obj);
        return Objects.equal(this.claims, other.claims);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)((Object)this)).omitNullValues().add("claims", this.claims).add("emissionTime", this.emissionTime).add("expirationTIme", this.expirationTime);
    }

    public static class Builder {
        private Set<String> requiredClaims;
        private ImmutableMap.Builder<String, String> claims = new ImmutableMap.Builder();
        private long emissionTime;
        private long expirationTime;

        public Builder() {
            this((Set<String>)ImmutableSet.of());
        }

        public Builder(String commaSeparatedRequiredClaims) {
            this((Set<String>)ImmutableSet.copyOf((Iterable)Splitter.on((String)",").split((CharSequence)Preconditions.checkNotNull((Object)commaSeparatedRequiredClaims))));
        }

        public Builder(Set<String> requiredClaims) {
            this.requiredClaims = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(requiredClaims)));
        }

        public Builder addClaim(String name, String value) {
            this.claims.put(Preconditions.checkNotNull((Object)name), Preconditions.checkNotNull((Object)value, (String)"value of %s", (Object[])new Object[]{name}));
            return this;
        }

        public Builder emissionTime(long emmissionTime) {
            this.emissionTime = emmissionTime;
            return this;
        }

        public Builder expirationTime(long expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder addAllClaims(Map<String, String> claims) {
            this.claims.putAll((Map)Preconditions.checkNotNull(claims));
            return this;
        }

        public ClaimSet build() {
            ImmutableMap claimsMap = this.claims.build();
            Preconditions.checkState((Sets.intersection(claimsMap.keySet(), this.requiredClaims).size() == this.requiredClaims.size() ? 1 : 0) != 0, (Object)"not all required claims were present");
            if (this.expirationTime == 0L) {
                this.expirationTime = this.emissionTime + 3600L;
            }
            return new ClaimSet((Map)claimsMap, this.emissionTime, this.expirationTime);
        }

        public Builder fromClaimSet(ClaimSet claimSet) {
            return new Builder().addAllClaims(claimSet.claims).expirationTime(this.expirationTime).emissionTime(this.emissionTime);
        }
    }
}

