/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class Header {
    private final String signerAlgorithm;
    private final String type;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Header.builder().fromHeader(this);
    }

    protected Header(String signerAlgorithm, String type) {
        this.signerAlgorithm = (String)Preconditions.checkNotNull((Object)signerAlgorithm);
        this.type = (String)Preconditions.checkNotNull((Object)type);
    }

    public String getSignerAlgorithm() {
        return this.signerAlgorithm;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Header other = (Header)obj;
        return Objects.equal((Object)this.signerAlgorithm, (Object)other.signerAlgorithm) && Objects.equal((Object)this.type, (Object)other.type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.signerAlgorithm, this.type});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("signerAlgorithm", (Object)this.signerAlgorithm).add("type", (Object)this.type);
    }

    public static class Builder {
        private String signerAlgorithm;
        private String type;

        public Builder signerAlgorithm(String signerAlgorithm) {
            this.signerAlgorithm = (String)Preconditions.checkNotNull((Object)signerAlgorithm);
            return this;
        }

        public Builder type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type);
            return this;
        }

        public Header build() {
            return new Header(this.signerAlgorithm, this.type);
        }

        public Builder fromHeader(Header header) {
            return new Builder().signerAlgorithm(header.signerAlgorithm).type(header.type);
        }
    }
}

