/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.oauth.v2.domain.ClaimSet;
import org.jclouds.oauth.v2.domain.Header;

public class TokenRequest {
    private final Header header;
    private final ClaimSet claimSet;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return TokenRequest.builder().fromTokenRequest(this);
    }

    public TokenRequest(Header header, ClaimSet claimSet) {
        this.header = (Header)Preconditions.checkNotNull((Object)header);
        this.claimSet = (ClaimSet)((Object)Preconditions.checkNotNull((Object)((Object)claimSet)));
    }

    public Header getHeader() {
        return this.header;
    }

    public ClaimSet getClaimSet() {
        return this.claimSet;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TokenRequest other = (TokenRequest)obj;
        return Objects.equal((Object)this.header, (Object)other.header) && Objects.equal((Object)((Object)this.claimSet), (Object)((Object)other.claimSet));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.header, this.claimSet});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("header", (Object)this.header).add("claimSet", (Object)this.claimSet);
    }

    public static class Builder {
        private Header header;
        private ClaimSet claimSet;

        public Builder header(Header header) {
            this.header = header;
            return this;
        }

        public Builder claimSet(ClaimSet claimSet) {
            this.claimSet = claimSet;
            return this;
        }

        public TokenRequest build() {
            return new TokenRequest(this.header, this.claimSet);
        }

        public Builder fromTokenRequest(TokenRequest tokeRequest) {
            return new Builder().header(tokeRequest.header).claimSet(tokeRequest.claimSet);
        }
    }
}

