/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Invokable;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.domain.ClaimSet;
import org.jclouds.oauth.v2.domain.Header;
import org.jclouds.oauth.v2.domain.OAuthCredentials;
import org.jclouds.oauth.v2.domain.TokenRequest;
import org.jclouds.oauth.v2.domain.TokenRequestFormat;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class BuildTokenRequest
implements Function<GeneratedHttpRequest, TokenRequest> {
    private final String assertionTargetDescription;
    private final String signatureAlgorithm;
    private final TokenRequestFormat tokenRequestFormat;
    private final Supplier<OAuthCredentials> credentialsSupplier;
    private final long tokenDuration;
    @Inject(optional=true)
    @Named(value="jclouds.oauth.additional-claims")
    protected Map<String, String> additionalClaims = ImmutableMap.of();
    @Inject(optional=true)
    @Named(value="jclouds.oauth.scopes")
    protected String globalScopes = null;
    @Inject(optional=true)
    protected Supplier<Long> timeSourceMillisSinceEpoch = new Supplier<Long>(){

        public Long get() {
            return System.currentTimeMillis();
        }
    };

    @Inject
    public BuildTokenRequest(@Named(value="jclouds.oauth.audience") String assertionTargetDescription, @Named(value="jclouds.oauth.signature-or-mac-algorithm") String signatureAlgorithm, TokenRequestFormat tokenRequestFormat, Supplier<OAuthCredentials> credentialsSupplier, @Named(value="jclouds.session-interval") long tokenDuration) {
        this.assertionTargetDescription = assertionTargetDescription;
        this.signatureAlgorithm = signatureAlgorithm;
        this.tokenRequestFormat = tokenRequestFormat;
        this.credentialsSupplier = credentialsSupplier;
        this.tokenDuration = tokenDuration;
    }

    public TokenRequest apply(GeneratedHttpRequest request) {
        long now = (Long)this.timeSourceMillisSinceEpoch.get() / 1000L;
        Header header = new Header.Builder().signerAlgorithm(this.signatureAlgorithm).type(this.tokenRequestFormat.getTypeName()).build();
        ClaimSet claimSet = new ClaimSet.Builder(this.tokenRequestFormat.requiredClaims()).addClaim("iss", ((OAuthCredentials)((Object)this.credentialsSupplier.get())).identity).addClaim("scope", this.getOAuthScopes(request)).addClaim("aud", this.assertionTargetDescription).emissionTime(now).expirationTime(now + this.tokenDuration).addAllClaims(this.additionalClaims).build();
        return new TokenRequest.Builder().header(header).claimSet(claimSet).build();
    }

    protected String getOAuthScopes(GeneratedHttpRequest request) {
        Invokable invokable = request.getInvocation().getInvokable();
        OAuthScopes classScopes = invokable.getOwnerType().getRawType().getAnnotation(OAuthScopes.class);
        OAuthScopes methodScopes = (OAuthScopes)invokable.getAnnotation(OAuthScopes.class);
        if (classScopes == null && methodScopes == null) {
            Preconditions.checkState((this.globalScopes != null ? 1 : 0) != 0, (Object)String.format("REST class or method should be annotated with OAuthScopes specifying required permissions. Alternatively a global property \"oauth.scopes\" may be set to define scopes globally. REST Class: %s, Method: %s", invokable.getOwnerType(), invokable.getName()));
            return this.globalScopes;
        }
        OAuthScopes scopes = methodScopes != null ? methodScopes : classScopes;
        return Joiner.on((String)",").join((Object[])scopes.value());
    }
}

