/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.crypto.Pems;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;
import org.jclouds.oauth.v2.OAuthConstants;
import org.jclouds.oauth.v2.domain.OAuthCredentials;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Throwables2;

@Singleton
public class OAuthCredentialsSupplier
implements Supplier<OAuthCredentials> {
    private final Supplier<Credentials> creds;
    private final LoadingCache<Credentials, OAuthCredentials> keyCache;

    @Inject
    public OAuthCredentialsSupplier(@Provider Supplier<Credentials> creds, OAuthCredentialsForCredentials loader, @Named(value="jclouds.oauth.signature-or-mac-algorithm") String signatureOrMacAlgorithm) {
        this.creds = creds;
        Preconditions.checkArgument((boolean)OAuthConstants.OAUTH_ALGORITHM_NAMES_TO_KEYFACTORY_ALGORITHM_NAMES.containsKey(signatureOrMacAlgorithm), (Object)String.format("No mapping for key factory for algorithm: %s", signatureOrMacAlgorithm));
        this.keyCache = CacheBuilder.newBuilder().maximumSize(2L).build((CacheLoader)Preconditions.checkNotNull((Object)((Object)loader), (Object)"loader"));
    }

    public OAuthCredentials get() {
        try {
            return (OAuthCredentials)((Object)this.keyCache.getUnchecked(Preconditions.checkNotNull((Object)this.creds.get(), (Object)"credential supplier returned null")));
        }
        catch (UncheckedExecutionException e) {
            Throwable authorizationException = Throwables2.getFirstThrowableOfType((Throwable)e, AuthorizationException.class);
            if (authorizationException != null) {
                throw (AuthorizationException)authorizationException;
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    @VisibleForTesting
    static class OAuthCredentialsForCredentials
    extends CacheLoader<Credentials, OAuthCredentials> {
        private final String keyFactoryAlgorithm;

        @Inject
        public OAuthCredentialsForCredentials(@Named(value="jclouds.oauth.signature-or-mac-algorithm") String signatureOrMacAlgorithm) {
            this.keyFactoryAlgorithm = OAuthConstants.OAUTH_ALGORITHM_NAMES_TO_KEYFACTORY_ALGORITHM_NAMES.get(Preconditions.checkNotNull((Object)signatureOrMacAlgorithm, (Object)"signatureOrMacAlgorithm"));
        }

        public OAuthCredentials load(Credentials in) {
            try {
                String identity = in.identity;
                String privateKeyInPemFormat = in.credential;
                if (this.keyFactoryAlgorithm.equals("none")) {
                    return new OAuthCredentials.Builder().identity(identity).credential(privateKeyInPemFormat).build();
                }
                KeyFactory keyFactory = KeyFactory.getInstance(this.keyFactoryAlgorithm);
                PrivateKey privateKey = keyFactory.generatePrivate(Pems.privateKeySpec((ByteSource)ByteSource.wrap((byte[])privateKeyInPemFormat.getBytes(Charsets.UTF_8))));
                return new OAuthCredentials.Builder().identity(identity).credential(privateKeyInPemFormat).privateKey(privateKey).build();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (GeneralSecurityException e) {
                throw new AuthorizationException("security exception loading credentials. " + e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new AuthorizationException("cannot parse pk. " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

