/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.handlers;

import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class OAuthErrorHandler
implements HttpErrorHandler {
    public void handleError(HttpCommand command, HttpResponse response) {
        byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
        String message = data != null ? new String(data) : null;
        Object exception = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatusCode());
        switch (status) {
            case BAD_REQUEST: {
                break;
            }
            case UNAUTHORIZED: 
            case FORBIDDEN: {
                exception = new AuthorizationException(message, (Throwable)exception);
                break;
            }
            case NOT_FOUND: {
                if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                exception = new ResourceNotFoundException(message, (Throwable)exception);
                break;
            }
            case CONFLICT: {
                exception = new IllegalStateException(message, (Throwable)exception);
            }
        }
        command.setException((Exception)exception);
    }
}

