/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.json;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.io.BaseEncoding;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.UrlEncodedFormPayload;
import org.jclouds.json.Json;
import org.jclouds.oauth.v2.domain.TokenRequest;
import org.jclouds.oauth.v2.domain.TokenRequestFormat;

@Singleton
public class JWTTokenRequestFormat
implements TokenRequestFormat {
    private static final String ASSERTION_FORM_PARAM = "assertion";
    private static final String GRANT_TYPE_FORM_PARAM = "grant_type";
    private static final String GRANT_TYPE_JWT_BEARER = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private final Function<byte[], byte[]> signer;
    private final Json json;

    @Inject
    public JWTTokenRequestFormat(Function<byte[], byte[]> signer, Json json) {
        this.signer = signer;
        this.json = json;
    }

    @Override
    public <R extends HttpRequest> R formatRequest(R request, TokenRequest tokenRequest) {
        String encodedHeader = this.json.toJson((Object)tokenRequest.getHeader());
        String encodedClaimSet = this.json.toJson((Object)tokenRequest.getClaimSet());
        encodedHeader = BaseEncoding.base64Url().omitPadding().encode(encodedHeader.getBytes(Charsets.UTF_8));
        encodedClaimSet = BaseEncoding.base64Url().omitPadding().encode(encodedClaimSet.getBytes(Charsets.UTF_8));
        byte[] signature = (byte[])this.signer.apply((Object)Joiner.on((String)".").join((Object)encodedHeader, (Object)encodedClaimSet, new Object[0]).getBytes(Charsets.UTF_8));
        String encodedSignature = signature != null ? BaseEncoding.base64Url().omitPadding().encode(signature) : "";
        String assertion = Joiner.on((String)".").join((Object)encodedHeader, (Object)encodedClaimSet, new Object[]{encodedSignature});
        UrlEncodedFormPayload payload = Payloads.newUrlEncodedFormPayload((Multimap)ImmutableMultimap.builder().put((Object)GRANT_TYPE_FORM_PARAM, (Object)GRANT_TYPE_JWT_BEARER).put((Object)ASSERTION_FORM_PARAM, (Object)assertion).build());
        return (R)((HttpRequest.Builder)request.toBuilder().payload((Payload)payload)).build();
    }

    @Override
    public String getTypeName() {
        return "JWT";
    }

    @Override
    public Set<String> requiredClaims() {
        return ImmutableSet.of((Object)"iss", (Object)"scope", (Object)"aud");
    }
}

