/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.oval.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Validateable;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.interceptor.PrefixMethodInvocationUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.Validator;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.MethodReturnValueContext;
import net.sf.oval.context.OValContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.oval.annotation.Profiles;
import org.apache.struts2.oval.interceptor.OValValidationManager;

public class OValValidationInterceptor
extends MethodFilterInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(OValValidationInterceptor.class);
    protected static final String VALIDATE_PREFIX = "validate";
    protected static final String ALT_VALIDATE_PREFIX = "validateDo";
    protected boolean alwaysInvokeValidate = true;
    protected boolean programmatic = true;
    protected OValValidationManager validationManager;
    private boolean validateJPAAnnotations;

    @Inject
    public void setValidationManager(OValValidationManager validationManager) {
        this.validationManager = validationManager;
    }

    public void setValidateJPAAnnotations(boolean validateJPAAnnotations) {
        this.validateJPAAnnotations = validateJPAAnnotations;
    }

    public void setProgrammatic(boolean programmatic) {
        this.programmatic = programmatic;
    }

    public void setAlwaysInvokeValidate(String alwaysInvokeValidate) {
        this.alwaysInvokeValidate = Boolean.parseBoolean(alwaysInvokeValidate);
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        ActionProxy proxy = invocation.getProxy();
        ValueStack valueStack = invocation.getStack();
        String methodName = proxy.getMethod();
        String context = proxy.getConfig().getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating [#0/#1] with method [#2]", new String[]{invocation.getProxy().getNamespace(), invocation.getProxy().getActionName(), methodName});
        }
        this.performOValValidation(action, valueStack, methodName, context);
        this.performProgrammaticValidation(invocation, action);
        return invocation.invoke();
    }

    private void performProgrammaticValidation(ActionInvocation invocation, Object action) throws Exception {
        if (action instanceof Validateable && this.programmatic) {
            Exception exception = null;
            Validateable validateable = (Validateable)action;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invoking validate() on action [#0]", new String[]{validateable.toString()});
            }
            try {
                PrefixMethodInvocationUtil.invokePrefixMethod((ActionInvocation)invocation, (String[])new String[]{VALIDATE_PREFIX, ALT_VALIDATE_PREFIX});
            }
            catch (Exception e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("An exception occured while executing the prefix method", (Throwable)e, new String[0]);
                }
                exception = e;
            }
            if (this.alwaysInvokeValidate) {
                validateable.validate();
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    protected void performOValValidation(Object action, ValueStack valueStack, String methodName, String context) throws NoSuchMethodException {
        Object[] profileNames;
        Profiles profiles;
        Class<?> clazz = action.getClass();
        List<Configurer> configurers = this.validationManager.getConfigurers(clazz, context, this.validateJPAAnnotations);
        Validator validator = configurers.isEmpty() ? new Validator() : new Validator(configurers);
        Method method = clazz.getMethod(methodName, new Class[0]);
        if (method != null && (profiles = method.getAnnotation(Profiles.class)) != null && (profileNames = profiles.value()) != null && profileNames.length > 0) {
            validator.disableAllProfiles();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Enabling profiles [#0]", new String[]{StringUtils.join((Object[])profileNames, (String)",")});
            }
            for (Object profileName : profileNames) {
                validator.enableProfile((String)profileName);
            }
        }
        List violations = validator.validate(action);
        this.addValidationErrors(violations.toArray(new ConstraintViolation[violations.size()]), action, valueStack, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addValidationErrors(ConstraintViolation[] violations, Object action, ValueStack valueStack, String parentFieldname) {
        if (violations != null) {
            DelegatingValidatorContext validatorContext = new DelegatingValidatorContext(action);
            for (ConstraintViolation violation : violations) {
                String key;
                String message = key = violation.getMessage();
                valueStack.push((Object)violation.getMessageVariables());
                valueStack.push((Object)violation.getContext());
                try {
                    message = validatorContext.getText(key);
                }
                finally {
                    valueStack.pop();
                    valueStack.pop();
                }
                if (this.isActionError(violation)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding action error '#0'", new String[]{message});
                    }
                    validatorContext.addActionError(message);
                    continue;
                }
                ValidationError validationError = this.buildValidationError(violation, message);
                String fieldName = validationError.getFieldName();
                if (parentFieldname != null) {
                    fieldName = parentFieldname + "." + fieldName;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding field error [#0] with message '#1'", new String[]{fieldName, validationError.getMessage()});
                }
                validatorContext.addFieldError(fieldName, validationError.getMessage());
                if (action instanceof ModelDriven && "model".equals(fieldName)) {
                    fieldName = null;
                }
                this.addValidationErrors(violation.getCauses(), action, valueStack, fieldName);
            }
        }
    }

    protected ValidationError buildValidationError(ConstraintViolation violation, String message) {
        OValContext context = violation.getContext();
        if (context instanceof FieldContext) {
            Field field = ((FieldContext)context).getField();
            String className = field.getDeclaringClass().getName();
            String finalMessage = StringUtils.removeStart((String)message, (String)(className + "."));
            return new ValidationError(field.getName(), finalMessage);
        }
        if (context instanceof MethodReturnValueContext) {
            Method method = ((MethodReturnValueContext)context).getMethod();
            String className = method.getDeclaringClass().getName();
            String methodName = method.getName();
            String finalMessage = StringUtils.removeStart((String)message, (String)(className + "."));
            String fieldName = null;
            if (methodName.startsWith("get")) {
                fieldName = StringUtils.uncapitalize((String)StringUtils.removeStart((String)methodName, (String)"get"));
            } else if (methodName.startsWith("is")) {
                fieldName = StringUtils.uncapitalize((String)StringUtils.removeStart((String)methodName, (String)"is"));
            }
            if (fieldName != null) {
                finalMessage = finalMessage.replaceAll(methodName + "\\(.*?\\)", fieldName);
            }
            return new ValidationError(StringUtils.defaultString((String)fieldName, (String)methodName), finalMessage);
        }
        return new ValidationError(violation.getCheckName(), message);
    }

    protected boolean isActionError(ConstraintViolation violation) {
        return false;
    }

    class ValidationError {
        private String fieldName;
        private String message;

        ValidationError(String fieldName, String message) {
            this.fieldName = fieldName;
            this.message = message;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

