/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.oval.interceptor;

import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.AnnotationsConfigurer;
import net.sf.oval.configuration.annotation.JPAAnnotationsConfigurer;
import net.sf.oval.configuration.xml.XMLConfigurer;
import org.apache.struts2.oval.interceptor.OValValidationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOValValidationManager
implements OValValidationManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOValValidationManager.class);
    protected static final String VALIDATION_CONFIG_SUFFIX = "-validation.xml";
    protected final Map<String, List<Configurer>> validatorCache = new HashMap<String, List<Configurer>>();
    protected final Map<String, Configurer> validatorFileCache = new HashMap<String, Configurer>();
    protected boolean validateJPAAnnotations;
    private FileManager fileManager;

    @Inject
    public void setFileManagerFactory(FileManagerFactory fileManagerFactory) {
        this.fileManager = fileManagerFactory.getFileManager();
    }

    @Override
    public synchronized List<Configurer> getConfigurers(Class clazz, String context, boolean validateJPAAnnotations) {
        this.validateJPAAnnotations = validateJPAAnnotations;
        String validatorKey = DefaultOValValidationManager.buildValidatorKey(clazz, context);
        if (this.validatorCache.containsKey(validatorKey)) {
            if (this.fileManager.isReloadingConfigs()) {
                List<Configurer> configurers = this.buildXMLConfigurers(clazz, context, true, null);
                this.addAditionalConfigurers(configurers);
                this.validatorCache.put(validatorKey, configurers);
            }
        } else {
            List<Configurer> configurers = this.buildXMLConfigurers(clazz, context, false, null);
            this.addAditionalConfigurers(configurers);
            this.validatorCache.put(validatorKey, configurers);
        }
        return this.validatorCache.get(validatorKey);
    }

    private void addAditionalConfigurers(List<Configurer> configurers) {
        AnnotationsConfigurer annotationsConfigurer = new AnnotationsConfigurer();
        configurers.add((Configurer)annotationsConfigurer);
        if (this.validateJPAAnnotations) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding support for JPA annotations validations in OVal", new String[0]);
            }
            configurers.add((Configurer)new JPAAnnotationsConfigurer());
        }
    }

    protected static String buildValidatorKey(Class clazz, String context) {
        StringBuilder sb = new StringBuilder(clazz.getName());
        sb.append("/");
        sb.append(context);
        return sb.toString();
    }

    private List<Configurer> buildXMLConfigurers(Class clazz, String context, boolean checkFile, Set<String> checked) {
        ArrayList<Configurer> configurers = new ArrayList<Configurer>();
        if (checked == null) {
            checked = new TreeSet<String>();
        } else if (checked.contains(clazz.getName())) {
            return configurers;
        }
        if (clazz.isInterface()) {
            for (Class<?> anInterface : clazz.getInterfaces()) {
                configurers.addAll(this.buildXMLConfigurers(anInterface, context, checkFile, checked));
            }
        } else if (!clazz.equals(Object.class)) {
            configurers.addAll(this.buildXMLConfigurers(clazz.getSuperclass(), context, checkFile, checked));
        }
        for (Class<?> anInterface1 : clazz.getInterfaces()) {
            if (checked.contains(anInterface1.getName())) continue;
            this.addIfNotNull(configurers, (Configurer)this.buildClassValidatorConfigs(anInterface1, checkFile));
            if (context != null) {
                this.addIfNotNull(configurers, (Configurer)this.buildAliasValidatorConfigs(anInterface1, context, checkFile));
            }
            checked.add(anInterface1.getName());
        }
        this.addIfNotNull(configurers, (Configurer)this.buildClassValidatorConfigs(clazz, checkFile));
        if (context != null) {
            this.addIfNotNull(configurers, (Configurer)this.buildAliasValidatorConfigs(clazz, context, checkFile));
        }
        checked.add(clazz.getName());
        return configurers;
    }

    protected void addIfNotNull(List<Configurer> configurers, Configurer configurer) {
        if (configurer != null) {
            configurers.add(configurer);
        }
    }

    protected XMLConfigurer buildAliasValidatorConfigs(Class aClass, String context, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + "-" + context + VALIDATION_CONFIG_SUFFIX;
        return this.loadFile(fileName, aClass, checkFile);
    }

    protected XMLConfigurer buildClassValidatorConfigs(Class aClass, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + VALIDATION_CONFIG_SUFFIX;
        return this.loadFile(fileName, aClass, checkFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XMLConfigurer loadFile(String fileName, Class clazz, boolean checkFile) {
        block14: {
            block13: {
                InputStream is;
                block11: {
                    XMLConfigurer xMLConfigurer;
                    block12: {
                        URL fileUrl = ClassLoaderUtil.getResource((String)fileName, (Class)clazz);
                        if ((!checkFile || !this.fileManager.fileNeedsReloading(fileUrl)) && this.validatorFileCache.containsKey(fileName)) break block13;
                        is = null;
                        try {
                            is = this.fileManager.loadFile(fileUrl);
                            if (is == null) break block11;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Loading validation xml file [#0]", new String[]{fileName});
                            }
                            XMLConfigurer configurer = new XMLConfigurer();
                            configurer.fromXML(is);
                            this.validatorFileCache.put(fileName, (Configurer)configurer);
                            xMLConfigurer = configurer;
                            if (is == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {
                                    LOG.error("Unable to close input stream for [#0] ", (Throwable)e, new String[]{fileName});
                                }
                            }
                            throw throwable;
                        }
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            LOG.error("Unable to close input stream for [#0] ", (Throwable)e, new String[]{fileName});
                        }
                    }
                    return xMLConfigurer;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.error("Unable to close input stream for [#0] ", (Throwable)e, new String[]{fileName});
                    }
                }
                break block14;
            }
            return (XMLConfigurer)this.validatorFileCache.get(fileName);
        }
        return null;
    }
}

