/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.handler;

import java.io.File;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.modules.Module;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.synapse.ServerManager;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.SynapseInitializationModule;

public class SynapseModule
implements Module {
    private static final Log log = LogFactory.getLog(SynapseModule.class);
    private SynapseInitializationModule initializationModule = null;

    public void init(ConfigurationContext configurationContext, AxisModule axisModule) throws AxisFault {
        if (System.getProperty("synapse.xml") == null) {
            ServerManager.getInstance().setSynapseXMLPath(configurationContext.getAxisConfiguration().getRepository().getPath() + "/conf/synapse.xml");
        }
        if (new File(ServerManager.getInstance().getSynapseXMLPath()).exists()) {
            this.initializationModule = new SynapseInitializationModule();
            this.initializationModule.init(configurationContext, axisModule);
            Parameter synEnv = configurationContext.getAxisConfiguration().getParameter("synapse.env");
            Parameter synCfg = configurationContext.getAxisConfiguration().getParameter("synapse.config");
            String message = "Unable to initialize the Synapse Configuration : Can not find the ";
            if (synCfg == null || synCfg.getValue() == null || !(synCfg.getValue() instanceof SynapseConfiguration)) {
                log.fatal((Object)(message + "Synapse Configuration"));
                throw new SynapseException(message + "Synapse Configuration");
            }
            if (synEnv == null || synEnv.getValue() == null || !(synEnv.getValue() instanceof SynapseEnvironment)) {
                log.fatal((Object)(message + "Synapse Environment"));
                throw new SynapseException(message + "Synapse Environment");
            }
            ((SynapseConfiguration)synCfg.getValue()).init((SynapseEnvironment)synEnv.getValue());
        } else {
            this.handleException("Unable to initialize the Synapse initializationModule. Couldn't find the configuration file in the location " + ServerManager.getInstance().getSynapseXMLPath());
        }
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
        if (this.initializationModule != null) {
            this.initializationModule.engageNotify(axisDescription);
        } else {
            this.handleException("Couldn't find the initializationModule");
        }
    }

    public boolean canSupportAssertion(Assertion assertion) {
        if (this.initializationModule != null) {
            return this.initializationModule.canSupportAssertion(assertion);
        }
        return false;
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {
        if (this.initializationModule != null) {
            this.initializationModule.applyPolicy(policy, axisDescription);
        } else {
            this.handleException("Couldn't find the initializationModule");
        }
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
        if (this.initializationModule != null) {
            this.initializationModule.shutdown(configurationContext);
        } else {
            this.handleException("Couldn't find the initializationModule");
        }
    }

    private void handleException(String message) throws AxisFault {
        log.error((Object)message);
        throw new AxisFault(message);
    }
}

