/*
 * Decompiled with CFR 0.152.
 */
package samples.mediators;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.AbstractMediator;

public class DiscountQuoteMediator
extends AbstractMediator {
    private static final Log log = LogFactory.getLog(DiscountQuoteMediator.class);
    private String discountFactor = "10";
    private String bonusFor = "10";
    private int bonusCount = 0;

    public boolean mediate(MessageContext mc) {
        String price = mc.getEnvelope().getBody().getFirstElement().getFirstElement().getFirstChildWithName(new QName("http://services.samples/xsd", "last")).getText();
        int discount = Integer.parseInt(this.discountFactor);
        int bonusNo = Integer.parseInt(this.bonusFor);
        double currentPrice = Double.parseDouble(price);
        Double lastPrice = new Double(currentPrice - currentPrice * (double)discount / 100.0);
        if (this.bonusCount <= bonusNo) {
            lastPrice = new Double(lastPrice - lastPrice * 0.05);
            ++this.bonusCount;
        }
        String discountedPrice = lastPrice.toString();
        mc.getEnvelope().getBody().getFirstElement().getFirstElement().getFirstChildWithName(new QName("http://services.samples/xsd", "last")).setText(discountedPrice);
        System.out.println("Quote value discounted.");
        System.out.println("Original price: " + price);
        System.out.println("Discounted price: " + discountedPrice);
        return true;
    }

    public String getType() {
        return null;
    }

    public void setTraceState(int traceState) {
        traceState = 0;
    }

    public int getTraceState() {
        return 0;
    }

    public void setDiscountFactor(String discount) {
        this.discountFactor = discount;
    }

    public String getDiscountFactor() {
        return this.discountFactor;
    }

    public void setBonusFor(String bonus) {
        this.bonusFor = bonus;
    }

    public String getBonusFor() {
        return this.bonusFor;
    }
}

