/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.io.File;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;

public class EventSender {
    public static void main(String[] args) {
        try {
            EventSender.executeClient();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }

    public static void executeClient() throws Exception {
        ServiceClient serviceClient;
        Options options = new Options();
        ConfigurationContext configContext = null;
        String addUrl = EventSender.getProperty("addurl", "http://localhost:8280/services/EventingProxy");
        String trpUrl = EventSender.getProperty("trpurl", null);
        String prxUrl = EventSender.getProperty("prxurl", null);
        String repo = EventSender.getProperty("repository", "client_repo");
        String symbol = EventSender.getProperty("symbol", "GOOG");
        String price = EventSender.getProperty("price", "10.10");
        String qty = EventSender.getProperty("qty", "1000");
        String topic = EventSender.getProperty("topic", "synapse/event/test");
        String action = EventSender.getProperty("action", "urn:event");
        String topicns = EventSender.getProperty("topicns", "http://apache.org/aip");
        if (repo != null && !"null".equals(repo)) {
            configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repo, (String)(repo + File.separator + "conf" + File.separator + "axis2.xml"));
            serviceClient = new ServiceClient(configContext, null);
        } else {
            serviceClient = new ServiceClient();
        }
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace nsaip = factory.createOMNamespace(topicns, "aip");
        OMElement topicOm = factory.createOMElement("Topic", nsaip);
        factory.createOMText((OMContainer)topicOm, topic);
        serviceClient.engageModule("addressing");
        options.setTo(new EndpointReference(addUrl));
        options.setAction(action);
        options.setProperty("transportNonBlocking", (Object)Boolean.FALSE);
        serviceClient.setOptions(options);
        serviceClient.addHeader(topicOm);
        OMElement payload = AXIOMUtil.stringToOM((String)("<m:placeOrder xmlns:m=\"http://services.samples/xsd\">\n    <m:order>\n        <m:price>" + price + "</m:price>\n" + "        <m:quantity>" + qty + "</m:quantity>\n" + "        <m:symbol>" + symbol + "</m:symbol>\n" + "    </m:order>\n" + "</m:placeOrder>"));
        System.out.println("Sending Event : \n" + payload.toString());
        try {
            serviceClient.fireAndForget(payload);
            System.out.println("Event sent to topic " + topic);
            Thread.sleep(1000L);
            if (configContext != null) {
                configContext.terminate();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }
}

