/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.io.File;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;

public class EventSubscriber {
    public static void main(String[] args) {
        try {
            EventSubscriber.executeClient();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }

    public static void executeClient() throws Exception {
        ServiceClient serviceClient;
        Options options = new Options();
        ConfigurationContext configContext = null;
        String addUrl = EventSubscriber.getProperty("addurl", "http://localhost:8280/services/SampleEventSource");
        String trpUrl = EventSubscriber.getProperty("trpurl", null);
        String prxUrl = EventSubscriber.getProperty("prxurl", null);
        String repo = EventSubscriber.getProperty("repository", "client_repo");
        String topic = EventSubscriber.getProperty("topic", "synapse/event/test");
        String address = EventSubscriber.getProperty("address", "http://localhost:9000/services/SimpleStockQuoteService");
        String mode = EventSubscriber.getProperty("mode", "subscribe");
        String identifier = EventSubscriber.getProperty("identifier", "90000");
        String expires = EventSubscriber.getProperty("expires", "*");
        if (repo != null && !"null".equals(repo)) {
            configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repo, (String)(repo + File.separator + "conf" + File.separator + "axis2.xml"));
            serviceClient = new ServiceClient(configContext, null);
        } else {
            serviceClient = new ServiceClient();
        }
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement message = factory.createOMElement("message", null);
        OMNamespace nsxmlins = factory.createOMNamespace("http://www.w3.org/2001/XMLSchema", "xmlns");
        OMNamespace nss11 = factory.createOMNamespace("http://schemas.xmlsoap.org/soap/envelope", "s11");
        OMNamespace nswsa = factory.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/08/addressing", "wsa");
        OMNamespace nswse = factory.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/08/eventing", "wse");
        if (mode.equals("subscribe")) {
            OMElement subscribeOm = factory.createOMElement("Subscribe", nswse);
            OMElement deliveryOm = factory.createOMElement("Delivery", nswse);
            deliveryOm.addAttribute(factory.createOMAttribute("Mode", null, "http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryModes/Push"));
            OMElement notifyToOm = factory.createOMElement("NotifyTo", nswse);
            OMElement addressOm = factory.createOMElement("Address", nswsa);
            factory.createOMText((OMContainer)addressOm, address);
            OMElement expiresOm = factory.createOMElement("Expires", nswse);
            factory.createOMText((OMContainer)expiresOm, expires);
            OMElement filterOm = factory.createOMElement("Filter", nswse);
            filterOm.addAttribute(factory.createOMAttribute("Dialect", null, "http://synapse.apache.org/eventing/dialect/topicFilter"));
            factory.createOMText((OMContainer)filterOm, topic);
            notifyToOm.addChild((OMNode)addressOm);
            deliveryOm.addChild((OMNode)notifyToOm);
            subscribeOm.addChild((OMNode)deliveryOm);
            if (!expires.equals("*")) {
                subscribeOm.addChild((OMNode)expiresOm);
            }
            subscribeOm.addChild((OMNode)filterOm);
            serviceClient.engageModule("addressing");
            options.setTo(new EndpointReference(addUrl));
            options.setAction("http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe");
            serviceClient.setOptions(options);
            System.out.println("Subscribing \n" + subscribeOm.toString());
            try {
                OMElement response = serviceClient.sendReceive(subscribeOm);
                System.out.println("Subscribed to topic " + topic);
                Thread.sleep(1000L);
                System.out.println("Response Received: " + response.toString());
                String subId = response.getFirstChildWithName(new QName(nswse.getNamespaceURI(), "SubscriptionManager")).getFirstChildWithName(new QName(nswsa.getNamespaceURI(), "ReferenceParameters")).getFirstChildWithName(new QName(nswse.getNamespaceURI(), "Identifier")).getText();
                System.out.println("Subscription identifier: " + subId);
            }
            catch (AxisFault e) {
                System.out.println("Fault Received : " + e.toString());
                System.out.println("Fault Code     : " + e.getFaultCode().toString());
            }
        } else if (mode.equals("unsubscribe")) {
            OMElement subscribeOm = factory.createOMElement("Unsubscribe", nswse);
            serviceClient.engageModule("addressing");
            options.setTo(new EndpointReference(addUrl));
            options.setAction("http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe");
            OMElement identifierOm = factory.createOMElement("Identifier", nswse);
            factory.createOMText((OMContainer)identifierOm, identifier);
            serviceClient.addHeader(identifierOm);
            serviceClient.setOptions(options);
            System.out.println("UnSubscribing \n" + subscribeOm.toString());
            try {
                OMElement response = serviceClient.sendReceive(subscribeOm);
                System.out.println("UnSubscribed to ID " + identifier);
                Thread.sleep(1000L);
                System.out.println("UnSubscribe Response Received: " + response.toString());
            }
            catch (AxisFault e) {
                System.out.println("Fault Received : " + e.toString());
                System.out.println("Fault Code     : " + e.getFaultCode().toString());
            }
        } else if (mode.equals("renew")) {
            OMElement subscribeOm = factory.createOMElement("Renew", nswse);
            OMElement expiresOm = factory.createOMElement("Expires", nswse);
            factory.createOMText((OMContainer)expiresOm, expires);
            subscribeOm.addChild((OMNode)expiresOm);
            serviceClient.engageModule("addressing");
            options.setTo(new EndpointReference(addUrl));
            options.setAction("http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew");
            OMElement identifierOm = factory.createOMElement("Identifier", nswse);
            factory.createOMText((OMContainer)identifierOm, identifier);
            serviceClient.addHeader(identifierOm);
            serviceClient.setOptions(options);
            System.out.println("SynapseSubscription Renew \n" + subscribeOm.toString());
            try {
                OMElement response = serviceClient.sendReceive(subscribeOm);
                System.out.println("SynapseSubscription Renew to ID " + identifier);
                Thread.sleep(1000L);
                System.out.println("SynapseSubscription Renew Response Received: " + response.toString());
            }
            catch (AxisFault e) {
                System.out.println("Fault Received : " + e.toString());
                System.out.println("Fault Code     : " + e.getFaultCode().toString());
            }
        } else if (mode.equals("getstatus")) {
            OMElement subscribeOm = factory.createOMElement("GetStatus", nswse);
            serviceClient.engageModule("addressing");
            options.setTo(new EndpointReference(addUrl));
            options.setAction("http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus");
            OMElement identifierOm = factory.createOMElement("Identifier", nswse);
            factory.createOMText((OMContainer)identifierOm, identifier);
            serviceClient.addHeader(identifierOm);
            serviceClient.setOptions(options);
            System.out.println("GetStatus using \n" + subscribeOm.toString());
            try {
                OMElement response = serviceClient.sendReceive(subscribeOm);
                System.out.println("GetStatus to ID " + identifier);
                Thread.sleep(1000L);
                System.out.println("GetStatus Response Received: " + response.toString());
            }
            catch (AxisFault e) {
                System.out.println("Fault Received : " + e.toString());
                System.out.println("Fault Code     : " + e.getFaultCode().toString());
            }
        }
        try {
            if (configContext != null) {
                configContext.terminate();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }
}

