/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.synapse.transport.jms.JMSUtils;

public class GenericJMSClient {
    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String dest = GenericJMSClient.getProperty("jms_dest", "dynamicQueues/JMSTextProxy");
        String type = GenericJMSClient.getProperty("jms_type", "text");
        String param = GenericJMSClient.getProperty("jms_payload", GenericJMSClient.getRandom(100.0, 0.9, true) + " " + (int)GenericJMSClient.getRandom(10000.0, 1.0, true) + " IBM");
        GenericJMSClient app = new GenericJMSClient();
        if ("text".equalsIgnoreCase(type)) {
            app.sendTextMessage(dest, param);
        } else if ("binary".equalsIgnoreCase(type)) {
            app.sendBytesMessage(dest, GenericJMSClient.getBytesFromFile(param));
        } else if ("pox".equalsIgnoreCase(type)) {
            app.sendTextMessage(dest, "<m:placeOrder xmlns:m=\"http://services.samples/xsd\">\n    <m:order>\n        <m:price>" + GenericJMSClient.getRandom(100.0, 0.9, true) + "</m:price>\n" + "        <m:quantity>" + (int)GenericJMSClient.getRandom(10000.0, 1.0, true) + "</m:quantity>\n" + "        <m:symbol>" + param + "</m:symbol>\n" + "    </m:order>\n" + "</m:placeOrder>");
        } else {
            System.out.println("Unknown JMS message type");
        }
    }

    private void sendBytesMessage(String destName, byte[] payload) throws Exception {
        InitialContext ic = this.getInitialContext();
        ConnectionFactory confac = (ConnectionFactory)ic.lookup("ConnectionFactory");
        Connection connection = JMSUtils.createConnection((ConnectionFactory)confac, null, null, (String)"queue");
        Session session = JMSUtils.createSession((Connection)connection, (boolean)false, (int)1, (String)"queue");
        BytesMessage bm = session.createBytesMessage();
        bm.writeBytes(payload);
        JMSUtils.sendMessageToJMSDestination((Session)session, (Destination)((Destination)ic.lookup(destName)), (String)"queue", (Message)bm);
        connection.close();
    }

    private void sendTextMessage(String destName, String payload) throws Exception {
        InitialContext ic = this.getInitialContext();
        ConnectionFactory confac = (ConnectionFactory)ic.lookup("ConnectionFactory");
        Connection connection = JMSUtils.createConnection((ConnectionFactory)confac, null, null, (String)"queue");
        Session session = JMSUtils.createSession((Connection)connection, (boolean)false, (int)1, (String)"queue");
        TextMessage tm = session.createTextMessage(payload);
        JMSUtils.sendMessageToJMSDestination((Session)session, (Destination)((Destination)ic.lookup(destName)), (String)"queue", (Message)tm);
        connection.close();
    }

    private InitialContext getInitialContext() throws NamingException {
        Properties env = new Properties();
        if (System.getProperty("java.naming.provider.url") == null) {
            env.put("java.naming.provider.url", "tcp://localhost:61616");
        }
        if (System.getProperty("java.naming.factory.initial") == null) {
            env.put("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        }
        return new InitialContext(env);
    }

    public static byte[] getBytesFromFile(String fileName) throws IOException {
        int offset;
        File file = new File(fileName);
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    private static double getRandom(double base, double varience, boolean onlypositive) {
        double rand = Math.random();
        return (base + (double)(rand > 0.5 ? 1 : -1) * varience * base * rand) * (double)(onlypositive ? 1 : (rand > 0.5 ? 1 : -1));
    }
}

