/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.ajax;

import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.web.WebRequest;
import org.apache.tapestry.web.WebSession;

public abstract class Timeout
extends BaseComponent {
    public abstract int getWarningTime();

    public abstract int getAutoProlongTime();

    public abstract String getWarningMessage();

    public abstract String getExpirationMessage();

    public abstract boolean getDisableWarning();

    public abstract boolean getDisableAutoProlong();

    public abstract String getExpirationFunction();

    public abstract WebRequest getRequest();

    protected WebSession getSession() {
        return this.getRequest().getSession(true);
    }

    protected int getSessionTime() {
        return this.getSession().getMaxInactiveInterval();
    }

    public boolean isInSession() {
        return this.getRequest().getSession(false) != null;
    }

    public Map getScriptSymbols() {
        int nSessionTime = this.getSessionTime();
        int nTimeToMessage = nSessionTime - this.getWarningTime();
        if (nTimeToMessage < 0) {
            nTimeToMessage = 0;
        }
        int nRemainingTime = nSessionTime - nTimeToMessage;
        int nAutoProlongTime = nSessionTime - this.getAutoProlongTime();
        HashMap<String, Object> mapSymbols = new HashMap<String, Object>();
        mapSymbols.put("confirmTimeout", new Integer(nTimeToMessage * 1000));
        mapSymbols.put("expirationTimeout", new Integer(nRemainingTime * 1000));
        mapSymbols.put("prolongSessionPeriod", new Integer(nAutoProlongTime * 1000));
        mapSymbols.put("confirmMessage", this.getWarningMessage());
        mapSymbols.put("expirationMessage", this.getExpirationMessage());
        mapSymbols.put("disableWarning", new Boolean(this.getDisableWarning()));
        mapSymbols.put("disableAutoProlong", new Boolean(this.getDisableAutoProlong()));
        mapSymbols.put("expirationFunction", this.getExpirationFunction());
        return mapSymbols;
    }

    public void renewSession(IRequestCycle cycle) {
    }
}

