/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.form.checkboxes;

import java.util.Collection;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.contrib.form.checkboxes.ControlledCheckbox;

public abstract class CheckboxGroup
extends BaseComponent {
    public static final String CHECKBOX_GROUP_ATTRIBUTE = "org.apache.tapestry.contrib.form.CheckboxGroup";

    public abstract Collection getCheckboxNames();

    public abstract String getFunctionName();

    public abstract void setFunctionName(String var1);

    public void registerControlledCheckbox(ControlledCheckbox checkbox) {
        String name = checkbox.getCheckboxName();
        String form = checkbox.getForm().getName();
        this.getCheckboxNames().add(form + "." + name);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        Object objOtherGroup = cycle.getAttribute(CHECKBOX_GROUP_ATTRIBUTE);
        cycle.setAttribute(CHECKBOX_GROUP_ATTRIBUTE, (Object)this);
        this.initialize(cycle);
        super.renderComponent(writer, cycle);
        this.getCheckboxNames().clear();
        cycle.setAttribute(CHECKBOX_GROUP_ATTRIBUTE, objOtherGroup);
    }

    private void initialize(IRequestCycle cycle) {
        PageRenderSupport body;
        String functionName = "setCheckboxGroup";
        if (!cycle.isRewinding() && (body = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this)) != null) {
            functionName = body.getUniqueString("setCheckboxGroup");
        }
        this.setFunctionName(functionName);
    }
}

