/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.link;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.NestedMarkupWriter;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.link.ILinkRenderer;

public class ButtonLinkRenderer
implements ILinkRenderer {
    public static final ILinkRenderer SHARED_INSTANCE = new ButtonLinkRenderer();

    public void renderLink(IMarkupWriter writer, IRequestCycle cycle, ILinkComponent component) {
        if (cycle.getAttribute("org.apache.tapestry.active-link-component") != null) {
            String message = Tapestry.getMessage((String)"AbstractLinkComponent.no-nesting");
            throw new ApplicationRuntimeException(message, (Object)component, null, null);
        }
        cycle.setAttribute("org.apache.tapestry.active-link-component", (Object)component);
        ILink link = component.getLink(cycle);
        writer.begin("button");
        writer.attribute("type", "button");
        if (component.isDisabled()) {
            writer.attribute("disabled", "disabled");
        }
        if (!cycle.isRewinding()) {
            String url = link.getURL(component.getAnchor(), true);
            String target = component.getTarget();
            String onclick = target == null ? this.getScript(url) : this.getScript(url, target);
            writer.attribute("onclick", onclick);
        }
        component.renderAdditionalAttributes(writer, cycle);
        NestedMarkupWriter wrappedWriter = writer.getNestedWriter();
        component.renderBody((IMarkupWriter)wrappedWriter, cycle);
        wrappedWriter.close();
        writer.end();
        cycle.removeAttribute("org.apache.tapestry.active-link-component");
    }

    protected String getScript(String url) {
        return "window.location='" + url + "'";
    }

    protected String getScript(String url, String target) {
        return "window.open('" + url + "','" + target + "')";
    }
}

