/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.link;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.link.DefaultLinkRenderer;
import org.apache.tapestry.link.ILinkRenderer;

public class FormLinkRenderer
extends DefaultLinkRenderer {
    public static final ILinkRenderer RENDERER = new FormLinkRenderer();

    public void renderLink(IMarkupWriter writer, IRequestCycle cycle, ILinkComponent linkComponent) {
        IMarkupWriter wrappedWriter = null;
        if (cycle.getAttribute("org.apache.tapestry.active-link-component") != null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage((String)"AbstractLinkComponent.no-nesting"), (Object)linkComponent, null, null);
        }
        cycle.setAttribute("org.apache.tapestry.active-link-component", (Object)linkComponent);
        String formName = cycle.getUniqueId("LinkForm");
        boolean hasBody = this.getHasBody();
        boolean disabled = linkComponent.isDisabled();
        if (!disabled && !cycle.isRewinding()) {
            ILink l = linkComponent.getLink(cycle);
            String anchor = linkComponent.getAnchor();
            PageRenderSupport prs = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)linkComponent);
            String function = this.generateFormFunction(formName, l, anchor);
            prs.addBodyScript((IComponent)linkComponent, function);
            if (hasBody) {
                writer.begin(this.getElement());
            } else {
                writer.beginEmpty(this.getElement());
            }
            writer.attribute(this.getUrlAttribute(), "javascript: document." + formName + ".submit();");
            this.beforeBodyRender(writer, cycle, linkComponent);
            wrappedWriter = writer.getNestedWriter();
        } else {
            wrappedWriter = writer;
        }
        if (hasBody) {
            linkComponent.renderBody(wrappedWriter, cycle);
        }
        if (!disabled && !cycle.isRewinding()) {
            this.afterBodyRender(writer, cycle, linkComponent);
            linkComponent.renderAdditionalAttributes(writer, cycle);
            if (hasBody) {
                wrappedWriter.close();
                writer.end();
            } else {
                writer.closeTag();
            }
        }
        cycle.removeAttribute("org.apache.tapestry.active-link-component");
    }

    private String generateFormFunction(String formName, ILink link, String anchor) {
        String[] parameterNames = link.getParameterNames();
        StringBuffer buf = new StringBuffer();
        buf.append("function prepare" + formName + "() {\n");
        buf.append("  var html = \"\";\n");
        buf.append("  html += \"<div style='position: absolute'>\";\n");
        String url = link.getURL(anchor, false);
        buf.append("  html += \"<form name='" + formName + "' method='post' action='" + url + "'>\";\n");
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameter = parameterNames[i];
            String[] values = link.getParameterValues(parameter);
            if (values == null) continue;
            for (int j = 0; j < values.length; ++j) {
                String value = values[j];
                buf.append("  html += \"<input type='hidden' name='" + parameter + "' value='" + value + "'/>\";\n");
            }
        }
        buf.append("  html += \"<\" + \"/form>\";\n");
        buf.append("  html += \"<\" + \"/div>\";\n");
        buf.append("  document.write(html);\n");
        buf.append("}\n");
        buf.append("prepare" + formName + "();\n\n");
        return buf.toString();
    }
}

