/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.services.impl;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.contrib.services.impl.ShadowRenderer;

public class RoundedCornerGenerator {
    public static final String TOP_LEFT = "tl";
    public static final String TOP_RIGHT = "tr";
    public static final String BOTTOM_LEFT = "bl";
    public static final String BOTTOM_RIGHT = "br";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    private static final Map _cssSpecMap = new HashMap();
    private static Color SHADOW_COLOR;
    private static final float DEFAULT_OPACITY = 0.5f;
    private static final float ANGLE_TOP_LEFT = 90.0f;
    private static final float ANGLE_TOP_RIGHT = 0.0f;
    private static final float ANGLE_BOTTOM_LEFT = 180.0f;
    private static final float ANGLE_BOTTOM_RIGHT = 270.0f;

    public BufferedImage buildCorner(String color, String backgroundColor, int width, int height, String angle, int shadowWidth, float endOpacity) throws Exception {
        Color bgColor;
        width *= 2;
        height *= 2;
        float startAngle = this.getStartAngle(angle);
        Color color2 = bgColor = backgroundColor == null ? null : this.decodeColor(backgroundColor);
        if (shadowWidth <= 0) {
            BufferedImage arc;
            BufferedImage ret = arc = this.drawArc(color, width, height, angle, false, -1);
            Arc2D.Float arcArea = new Arc2D.Float(0.0f, 0.0f, width, height, startAngle, 90.0f, 2);
            if (bgColor != null) {
                ret = new BufferedImage(width, height, 2);
                Graphics2D g2 = ret.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setColor(bgColor);
                g2.fill(arcArea.getBounds2D());
                g2.drawImage((Image)arc, 0, 0, null);
                g2.dispose();
                ret = RoundedCornerGenerator.convertType(ret, 1);
            }
            return ret.getSubimage((int)arcArea.getBounds2D().getX(), (int)arcArea.getBounds2D().getY(), (int)arcArea.getBounds2D().getWidth(), (int)arcArea.getBounds2D().getHeight());
        }
        BufferedImage mask = this.drawArc(color, width, height, angle, true, shadowWidth);
        BufferedImage arc = this.drawArc(color, width, height, angle, false, shadowWidth);
        float startX = 0.0f;
        float startY = 0.0f;
        int shadowSize = shadowWidth * 2;
        float canvasWidth = width + shadowSize * 2;
        float canvasHeight = height + shadowSize * 2;
        if (startAngle == 180.0f) {
            startY -= (float)(shadowSize * 2);
        } else if (startAngle == 0.0f) {
            startX -= (float)(shadowSize * 2);
        } else if (startAngle == 270.0f) {
            startX -= (float)(shadowSize * 2);
            startY -= (float)(shadowSize * 2);
        }
        BufferedImage ret = new BufferedImage(width, height, 2);
        Graphics2D g2 = ret.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Arc2D.Float arcArea = new Arc2D.Float(startX, startY, canvasWidth, canvasHeight, startAngle, 90.0f, 2);
        if (bgColor != null) {
            g2.setColor(bgColor);
            g2.fill(arcArea.getBounds2D());
        }
        BufferedImage shadow = this.drawArcShadow(mask, color, backgroundColor, width, height, angle, shadowWidth, endOpacity);
        g2.setClip(arcArea);
        g2.drawImage((Image)shadow, 0, 0, null);
        g2.setClip(null);
        g2.drawImage((Image)arc, 0, 0, null);
        return RoundedCornerGenerator.convertType(ret, 1).getSubimage((int)arcArea.getBounds2D().getX(), (int)arcArea.getBounds2D().getY(), (int)arcArea.getBounds2D().getWidth(), (int)arcArea.getBounds2D().getHeight());
    }

    static BufferedImage convertType(BufferedImage image, int type) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), type);
        Graphics2D g = result.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.drawRenderedImage(image, null);
        g.dispose();
        return result;
    }

    BufferedImage drawArc(String color, int width, int height, String angle, boolean masking, int shadowWidth) {
        Color arcColor = this.decodeColor(color);
        float startAngle = this.getStartAngle(angle);
        int canvasWidth = width;
        int canvasHeight = height;
        float startX = 0.0f;
        float startY = 0.0f;
        int shadowSize = 0;
        if (shadowWidth > 0 && !masking) {
            shadowSize = shadowWidth * 2;
            canvasWidth += shadowSize * 2;
            canvasHeight += shadowSize * 2;
            if (startAngle == 90.0f) {
                startX += (float)shadowSize;
                startY += (float)shadowSize;
            } else if (startAngle == 180.0f) {
                startX += (float)shadowSize;
                startY -= (float)shadowSize;
            } else if (startAngle == 0.0f) {
                startX -= (float)shadowSize;
                startY += (float)shadowSize;
            } else if (startAngle == 270.0f) {
                startX -= (float)shadowSize;
                startY -= (float)shadowSize;
            }
        }
        BufferedImage img = new BufferedImage(canvasWidth, canvasHeight, 2);
        Graphics2D g2 = img.createGraphics();
        float extent = 90.0f;
        if (masking) {
            extent = 120.0f;
            startAngle -= 20.0f;
        }
        Arc2D.Float fillArea = new Arc2D.Float(startX, startY, width, height, startAngle, extent, 2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setColor(arcColor);
        g2.setComposite(AlphaComposite.Src);
        g2.fill(fillArea);
        g2.dispose();
        return img;
    }

    BufferedImage drawArcShadow(BufferedImage mask, String color, String backgroundColor, int width, int height, String angle, int shadowWidth, float endOpacity) {
        float startAngle = this.getStartAngle(angle);
        int shadowSize = shadowWidth * 2;
        int sampleY = 0;
        int sampleX = 0;
        int sampleWidth = width + shadowSize;
        int sampleHeight = height + shadowSize;
        if (startAngle != 90.0f) {
            if (startAngle == 180.0f) {
                sampleWidth -= shadowSize;
                sampleHeight = height;
                sampleY += shadowSize;
            } else if (startAngle == 0.0f) {
                sampleWidth -= shadowSize;
                sampleHeight -= shadowSize;
                sampleX += shadowSize;
            } else if (startAngle == 270.0f) {
                sampleWidth -= shadowSize;
                sampleHeight -= shadowSize;
                sampleX += shadowSize;
                sampleY += shadowSize;
            }
        }
        ShadowRenderer shadowRenderer = new ShadowRenderer(shadowWidth, endOpacity, SHADOW_COLOR);
        BufferedImage dropShadow = shadowRenderer.createShadow(mask);
        BufferedImage img = new BufferedImage(width * 4, height * 4, 2);
        Graphics2D g2 = img.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.Src);
        g2.drawImage((Image)dropShadow, 0, 0, null);
        g2.dispose();
        return img.getSubimage(sampleX, sampleY, sampleWidth, sampleHeight);
    }

    public BufferedImage buildShadow(String color, String backgroundColor, int width, int height, float arcWidth, float arcHeight, int shadowWidth, float endOpacity) {
        Color fgColor = color == null ? Color.WHITE : this.decodeColor(color);
        Color bgColor = backgroundColor == null ? null : this.decodeColor(backgroundColor);
        BufferedImage mask = new BufferedImage(width, height, 2);
        Graphics2D g2 = mask.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RoundRectangle2D.Float fillArea = new RoundRectangle2D.Float(0.0f, 0.0f, width, height, arcHeight, arcWidth);
        g2.setColor(fgColor);
        g2.fill(fillArea);
        g2.dispose();
        ShadowRenderer shadowRenderer = new ShadowRenderer(shadowWidth, endOpacity, SHADOW_COLOR);
        BufferedImage dropShadow = shadowRenderer.createShadow(mask);
        BufferedImage clipImg = new BufferedImage(width + shadowWidth * 2, height + shadowWidth * 2, 2);
        g2 = clipImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.Src);
        RoundRectangle2D.Float clip = new RoundRectangle2D.Float(0.0f, 0.0f, width + shadowWidth * 2, height + shadowWidth * 2, arcHeight, arcWidth);
        g2.setClip(clip);
        g2.drawImage((Image)dropShadow, 0, 0, null);
        g2.dispose();
        BufferedImage img = new BufferedImage(width + shadowWidth * 2, height + shadowWidth * 2, 2);
        g2 = img.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (bgColor != null) {
            fillArea = new RoundRectangle2D.Float(0.0f, 0.0f, width + shadowWidth * 2, height + shadowWidth * 2, arcHeight, arcWidth);
            g2.setColor(bgColor);
            g2.fill(fillArea.getBounds2D());
        }
        g2.drawImage((Image)clipImg, 0, 0, null);
        if (fgColor != null) {
            fillArea = new RoundRectangle2D.Float(0.0f, 0.0f, width, height, arcHeight, arcWidth);
            g2.setColor(fgColor);
            g2.fill(fillArea);
        }
        g2.dispose();
        return RoundedCornerGenerator.convertType(img, 1);
    }

    public BufferedImage buildSideShadow(String side, int size, float opacity) throws Exception {
        Defense.notNull((Object)side, (String)"side");
        if (opacity <= 0.0f) {
            opacity = 0.5f;
        }
        int maskWidth = 0;
        int maskHeight = 0;
        int sampleY = 0;
        int sampleX = 0;
        int sampleWidth = 0;
        int sampleHeight = 0;
        if (LEFT.equals(side)) {
            maskWidth = size * 4;
            maskHeight = size * 4;
            sampleY = maskHeight / 2;
            sampleWidth = size * 2;
            sampleHeight = 2;
        } else if (RIGHT.equals(side)) {
            maskWidth = size * 4;
            maskHeight = size * 4;
            sampleY = maskHeight / 2;
            sampleX = maskWidth;
            sampleWidth = size * 2;
            sampleHeight = 2;
        } else if (BOTTOM.equals(side)) {
            maskWidth = size * 4;
            sampleY = maskHeight = size * 4;
            sampleX = maskWidth / 2;
            sampleWidth = 2;
            sampleHeight = size * 2;
        } else if (TOP.equals(side)) {
            maskWidth = size * 4;
            maskHeight = size * 4;
            sampleY = 0;
            sampleX = maskWidth / 2;
            sampleWidth = 2;
            sampleHeight = size * 2;
        }
        BufferedImage mask = new BufferedImage(maskWidth, maskHeight, 2);
        Graphics2D g2 = mask.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, maskWidth, maskHeight);
        g2.dispose();
        ShadowRenderer shadowRenderer = new ShadowRenderer(size, opacity, SHADOW_COLOR);
        BufferedImage dropShadow = shadowRenderer.createShadow(mask);
        BufferedImage render = new BufferedImage(maskWidth * 2, maskHeight * 2, 2);
        g2 = render.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle2D.Float clip = new Rectangle2D.Float(sampleX, sampleY, sampleWidth, sampleHeight);
        g2.setColor(Color.white);
        g2.fill(clip);
        g2.drawImage((Image)dropShadow, 0, 0, null);
        g2.dispose();
        return render.getSubimage(sampleX, sampleY, sampleWidth, sampleHeight);
    }

    public float getStartAngle(String code) {
        if (TOP_LEFT.equalsIgnoreCase(code)) {
            return 90.0f;
        }
        if (TOP_RIGHT.equalsIgnoreCase(code)) {
            return 0.0f;
        }
        if (BOTTOM_LEFT.equalsIgnoreCase(code)) {
            return 180.0f;
        }
        if (BOTTOM_RIGHT.equalsIgnoreCase(code)) {
            return 270.0f;
        }
        return 0.0f;
    }

    public Color decodeColor(String color) {
        Color specColor = (Color)_cssSpecMap.get(color);
        if (specColor != null) {
            return specColor;
        }
        String hexColor = color.startsWith("0x") ? color : "0x" + color;
        return Color.decode(hexColor);
    }

    static {
        _cssSpecMap.put("aqua", new Color(0, 255, 255));
        _cssSpecMap.put("black", Color.black);
        _cssSpecMap.put("blue", Color.blue);
        _cssSpecMap.put("fuchsia", new Color(255, 0, 255));
        _cssSpecMap.put("gray", Color.gray);
        _cssSpecMap.put("green", Color.green);
        _cssSpecMap.put("lime", new Color(0, 255, 0));
        _cssSpecMap.put("maroon", new Color(128, 0, 0));
        _cssSpecMap.put("navy", new Color(0, 0, 128));
        _cssSpecMap.put("olive", new Color(128, 128, 0));
        _cssSpecMap.put("purple", new Color(128, 0, 128));
        _cssSpecMap.put("red", Color.red);
        _cssSpecMap.put("silver", new Color(192, 192, 192));
        _cssSpecMap.put("teal", new Color(0, 128, 128));
        _cssSpecMap.put("white", Color.white);
        _cssSpecMap.put("yellow", Color.yellow);
        ImageIO.setUseCache(false);
        SHADOW_COLOR = new Color(0);
    }
}

