/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.model.ognl;

import org.apache.tapestry.contrib.table.model.ITableColumn;
import org.apache.tapestry.contrib.table.model.ognl.ExpressionTableColumn;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableColumnModel;
import org.apache.tapestry.services.ExpressionEvaluator;

public class ExpressionTableColumnModel
extends SimpleTableColumnModel {
    private static final long serialVersionUID = 1L;

    public ExpressionTableColumnModel(String[] arrColumnInfo, boolean bSorted, ExpressionEvaluator expressionEvaluator) {
        this(ExpressionTableColumnModel.convertToDetailedArray(arrColumnInfo, bSorted), expressionEvaluator);
    }

    public ExpressionTableColumnModel(Object[] arrColumnInfo, ExpressionEvaluator expressionEvaluator) {
        super(ExpressionTableColumnModel.convertToColumns(arrColumnInfo, expressionEvaluator));
    }

    protected static Object[] convertToDetailedArray(String[] arrColumnInfo, boolean bSorted) {
        int nColumns = arrColumnInfo.length / 2;
        int nSize = nColumns * 4;
        Object[] arrDetailedInfo = new Object[nSize];
        for (int i = 0; i < nColumns; ++i) {
            int nInputBaseIndex = 2 * i;
            String strColumnName = arrColumnInfo[nInputBaseIndex];
            String strExpression = arrColumnInfo[nInputBaseIndex + 1];
            int nOutputBaseIndex = 4 * i;
            arrDetailedInfo[nOutputBaseIndex] = strColumnName;
            arrDetailedInfo[nOutputBaseIndex + 1] = strColumnName;
            arrDetailedInfo[nOutputBaseIndex + 2] = strExpression;
            arrDetailedInfo[nOutputBaseIndex + 3] = bSorted ? Boolean.TRUE : Boolean.FALSE;
        }
        return arrDetailedInfo;
    }

    protected static ITableColumn[] convertToColumns(Object[] arrDetailedInfo, ExpressionEvaluator expressionEvaluator) {
        int nColumns = arrDetailedInfo.length / 4;
        ITableColumn[] arrColumns = new ITableColumn[nColumns];
        for (int i = 0; i < nColumns; ++i) {
            int nBaseIndex = 4 * i;
            String strColumnName = "";
            Object objTempValue = arrDetailedInfo[nBaseIndex];
            if (objTempValue != null) {
                strColumnName = objTempValue.toString();
            }
            String strDisplayName = "";
            objTempValue = arrDetailedInfo[nBaseIndex + 1];
            if (objTempValue != null) {
                strDisplayName = objTempValue.toString();
            }
            String strExpression = "";
            objTempValue = arrDetailedInfo[nBaseIndex + 2];
            if (objTempValue != null) {
                strExpression = objTempValue.toString();
            }
            boolean bSorted = false;
            objTempValue = arrDetailedInfo[nBaseIndex + 3];
            if (objTempValue != null) {
                bSorted = objTempValue instanceof Boolean ? ((Boolean)objTempValue).booleanValue() : Boolean.valueOf(objTempValue.toString()).booleanValue();
            }
            arrColumns[i] = new ExpressionTableColumn(strColumnName, strDisplayName, strExpression, bSorted, expressionEvaluator);
        }
        return arrColumns;
    }
}

