/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.model.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.contrib.table.model.ITablePagingState;
import org.apache.tapestry.contrib.table.model.ITableSortingState;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableState;
import org.apache.tapestry.contrib.table.model.sql.ISqlConnectionSource;
import org.apache.tapestry.contrib.table.model.sql.ISqlTableDataSource;
import org.apache.tapestry.contrib.table.model.sql.SqlTableColumn;
import org.apache.tapestry.contrib.table.model.sql.SqlTableColumnModel;

public class SimpleSqlTableDataSource
implements ISqlTableDataSource {
    private static final Log LOG = LogFactory.getLog((Class)SimpleSqlTableDataSource.class);
    private ISqlConnectionSource m_objConnSource;
    private String m_strTableName;
    private String m_strWhereClause;

    public SimpleSqlTableDataSource(ISqlConnectionSource objConnSource, String strTableName) {
        this(objConnSource, strTableName, null);
    }

    public SimpleSqlTableDataSource(ISqlConnectionSource objConnSource, String strTableName, String strWhereClause) {
        this.setConnSource(objConnSource);
        this.setTableName(strTableName);
        this.setWhereClause(strWhereClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() throws SQLException {
        String strQuery = this.generateCountQuery();
        LOG.trace((Object)("Invoking query to count rows: " + strQuery));
        Connection objConn = this.getConnSource().obtainConnection();
        try {
            int n;
            Statement objStmt = objConn.createStatement();
            try {
                ResultSet objRS = objStmt.executeQuery(strQuery);
                objRS.next();
                n = objRS.getInt(1);
            }
            catch (Throwable throwable) {
                objStmt.close();
                throw throwable;
            }
            objStmt.close();
            return n;
        }
        finally {
            this.getConnSource().returnConnection(objConn);
        }
    }

    public ResultSet getCurrentRows(SqlTableColumnModel objColumnModel, SimpleTableState objState) throws SQLException {
        String strQuery = this.generateDataQuery(objColumnModel, objState);
        LOG.trace((Object)("Invoking query to load current rows: " + strQuery));
        Connection objConn = this.getConnSource().obtainConnection();
        Statement objStmt = objConn.createStatement();
        return objStmt.executeQuery(strQuery);
    }

    public void closeResultSet(ResultSet objResultSet) {
        try {
            Statement objStmt = objResultSet.getStatement();
            Connection objConn = objStmt.getConnection();
            try {
                objResultSet.close();
                objStmt.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.getConnSource().returnConnection(objConn);
        }
        catch (SQLException e) {
            LOG.warn((Object)"Error while closing the result set", (Throwable)e);
        }
    }

    protected String quoteObjectName(String strObject) {
        return strObject;
    }

    public String getTableName() {
        return this.m_strTableName;
    }

    public void setTableName(String tableName) {
        this.m_strTableName = tableName;
    }

    public ISqlConnectionSource getConnSource() {
        return this.m_objConnSource;
    }

    public void setConnSource(ISqlConnectionSource connSource) {
        this.m_objConnSource = connSource;
    }

    public String getWhereClause() {
        return this.m_strWhereClause;
    }

    public void setWhereClause(String whereClause) {
        this.m_strWhereClause = whereClause;
    }

    protected String generateColumnList(SqlTableColumnModel objColumnModel) {
        StringBuffer objColumnBuf = new StringBuffer();
        for (int i = 0; i < objColumnModel.getColumnCount(); ++i) {
            SqlTableColumn objColumn = objColumnModel.getSqlColumn(i);
            if (i > 0) {
                objColumnBuf.append(", ");
            }
            objColumnBuf.append(this.quoteObjectName(objColumn.getColumnName()));
        }
        return objColumnBuf.toString();
    }

    protected String generateWhereClause() {
        String strWhereClause = this.getWhereClause();
        if (strWhereClause == null || strWhereClause.equals("")) {
            return "";
        }
        return "WHERE " + strWhereClause + " ";
    }

    protected String generateOrderByClause(ITableSortingState objSortingState) {
        StringBuffer objSortingBuf = new StringBuffer();
        if (objSortingState.getSortColumn() != null) {
            objSortingBuf.append("ORDER BY ");
            objSortingBuf.append(objSortingState.getSortColumn());
            if (!objSortingState.getSortOrder()) {
                objSortingBuf.append(" ASC ");
            } else {
                objSortingBuf.append(" DESC ");
            }
        }
        return objSortingBuf.toString();
    }

    protected String generateLimitClause(ITablePagingState objPagingState) {
        int nPageSize = objPagingState.getPageSize();
        int nStart = objPagingState.getCurrentPage() * nPageSize;
        return "LIMIT " + nPageSize + " OFFSET " + nStart + " ";
    }

    protected String generateDataQuery(SqlTableColumnModel objColumnModel, SimpleTableState objState) {
        return "SELECT " + this.generateColumnList(objColumnModel) + " FROM " + this.getTableName() + " " + this.generateWhereClause() + this.generateOrderByClause(objState.getSortingState()) + this.generateLimitClause(objState.getPagingState());
    }

    protected String generateCountQuery() {
        return "SELECT COUNT(*) FROM " + this.getTableName() + " " + this.generateWhereClause();
    }
}

