/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.model.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.contrib.table.model.ITableColumnModel;
import org.apache.tapestry.contrib.table.model.common.AbstractTableModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableState;
import org.apache.tapestry.contrib.table.model.sql.ISqlTableDataSource;
import org.apache.tapestry.contrib.table.model.sql.ResultSetIterator;
import org.apache.tapestry.contrib.table.model.sql.SqlTableColumnModel;

public class SqlTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((Class)SqlTableModel.class);
    private ISqlTableDataSource m_objDataSource;
    private SqlTableColumnModel m_objColumnModel;

    public SqlTableModel(ISqlTableDataSource objDataSource, SqlTableColumnModel objColumnModel) {
        this(objDataSource, objColumnModel, new SimpleTableState());
    }

    public SqlTableModel(ISqlTableDataSource objDataSource, SqlTableColumnModel objColumnModel, SimpleTableState objState) {
        super(objState);
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (Exception e) {
            System.out.println("ERROR: failed to load HSQLDB JDBC driver.");
            e.printStackTrace();
        }
        this.m_objDataSource = objDataSource;
        this.m_objColumnModel = objColumnModel;
    }

    public ITableColumnModel getColumnModel() {
        return this.m_objColumnModel;
    }

    public SqlTableColumnModel getSqlColumnModel() {
        return this.m_objColumnModel;
    }

    public Iterator getCurrentPageRows() {
        try {
            ResultSet objResultSet = this.getSqlDataSource().getCurrentRows(this.getSqlColumnModel(), this.getState());
            return new ResultSetIterator(objResultSet){

                protected void notifyEnd() {
                    SqlTableModel.this.getSqlDataSource().closeResultSet(this.getResultSet());
                }
            };
        }
        catch (SQLException e) {
            LOG.error((Object)"Cannot get current page rows", (Throwable)e);
            return new ResultSetIterator(null);
        }
    }

    public ISqlTableDataSource getSqlDataSource() {
        return this.m_objDataSource;
    }

    public int getRowCount() {
        try {
            return this.m_objDataSource.getRowCount();
        }
        catch (SQLException e) {
            LOG.error((Object)"Cannot get row count", (Throwable)e);
            return 1;
        }
    }
}

