/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.ResumeCallback;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.Response;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationCallback;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;

public class AsyncResponseImpl
implements AsyncResponse,
ContinuationCallback {
    private Continuation cont;
    private Message inMessage;
    private boolean initialSuspend;
    private boolean cancelled;
    private volatile boolean done;
    private boolean resumedByApplication;
    private TimeoutHandler timeoutHandler;
    private CompletionCallback completionCallback;

    public AsyncResponseImpl(Message inMessage) {
        inMessage.put(AsyncResponse.class, this);
        inMessage.getExchange().put(ContinuationCallback.class, this);
        this.inMessage = inMessage;
        this.initContinuation();
    }

    @Override
    public void resume(Object response) throws IllegalStateException {
        this.doResume(response);
    }

    @Override
    public void resume(Throwable response) throws IllegalStateException {
        this.doResume(response);
    }

    private synchronized void doResume(Object response) throws IllegalStateException {
        this.checkCancelled();
        this.checkSuspended();
        this.inMessage.getExchange().put(AsyncResponse.class, this);
        this.cont.setObject(response);
        this.resumedByApplication = true;
        if (!this.initialSuspend) {
            this.cont.resume();
        } else {
            this.initialSuspend = false;
        }
    }

    @Override
    public void cancel() {
        this.doCancel(null);
    }

    @Override
    public void cancel(int retryAfter) {
        this.doCancel(Integer.toString(retryAfter));
    }

    @Override
    public void cancel(Date retryAfter) {
        this.doCancel(HttpUtils.getHttpDateFormat().format(retryAfter));
    }

    private synchronized void doCancel(String retryAfterHeader) {
        this.checkSuspended();
        Response.ResponseBuilder rb = Response.status(503);
        if (retryAfterHeader != null) {
            rb.header("Retry-After", retryAfterHeader);
        }
        this.doResume(rb.build());
        this.cancelled = true;
    }

    @Override
    public synchronized boolean isSuspended() {
        return this.cont.isPending();
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public synchronized void setTimeout(long time, TimeUnit unit) throws IllegalStateException {
        this.checkCancelled();
        this.checkSuspended();
        this.inMessage.getExchange().put(AsyncResponse.class, this);
        long timeout = TimeUnit.MILLISECONDS.convert(time, unit);
        this.initialSuspend = false;
        this.cont.suspend(timeout);
    }

    @Override
    public void setTimeoutHandler(TimeoutHandler handler) {
        this.timeoutHandler = handler;
    }

    @Override
    public boolean register(Class<?> callback) throws NullPointerException {
        return this.register(callback, CompletionCallback.class)[0];
    }

    @Override
    public boolean[] register(Class<?> callback, Class<?> ... callbacks) throws NullPointerException {
        try {
            return this.register(callback.newInstance(), CompletionCallback.class);
        }
        catch (Throwable t) {
            return new boolean[]{false};
        }
    }

    @Override
    public boolean register(Object callback) throws NullPointerException {
        return this.register(callback, CompletionCallback.class, ResumeCallback.class)[0];
    }

    @Override
    public boolean[] register(Object callback, Object ... callbacks) throws NullPointerException {
        boolean[] result = new boolean[callbacks.length];
        for (int i = 0; i < callbacks.length; ++i) {
            Object interf = callbacks[i];
            if (interf == null) {
                throw new NullPointerException();
            }
            Class cls = (Class)interf;
            if (cls == CompletionCallback.class && callback instanceof CompletionCallback) {
                this.completionCallback = (CompletionCallback)callback;
                result[i] = true;
                continue;
            }
            result[i] = false;
        }
        return result;
    }

    private void checkCancelled() {
        if (this.cancelled) {
            throw new IllegalStateException();
        }
    }

    private void checkSuspended() {
        if (!this.initialSuspend && !this.isSuspended()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void onComplete() {
        this.done = true;
        if (this.completionCallback != null) {
            this.completionCallback.onComplete();
        }
    }

    @Override
    public void onError(Throwable error) {
        if (this.completionCallback != null) {
            Throwable actualError = error instanceof Fault ? ((Fault)error).getCause() : error;
            this.completionCallback.onError(actualError);
        }
    }

    public synchronized void suspendContinuation() {
        this.initialSuspend = false;
        this.cont.suspend(0L);
    }

    public synchronized Object getResponseObject() {
        Object obj = this.cont.getObject();
        if (!(obj instanceof Response) && !(obj instanceof Throwable)) {
            obj = Response.ok().entity(obj).build();
        }
        return obj;
    }

    public synchronized boolean isResumedByApplication() {
        return this.resumedByApplication;
    }

    public synchronized void handleTimeout() {
        if (!this.resumedByApplication) {
            if (this.timeoutHandler != null) {
                this.timeoutHandler.handleTimeout(this);
            } else {
                this.cont.setObject(new ServiceUnavailableException());
            }
        }
    }

    private void initContinuation() {
        ContinuationProvider provider = (ContinuationProvider)this.inMessage.get(ContinuationProvider.class.getName());
        this.cont = provider.getContinuation();
        this.initialSuspend = true;
    }

    public void prepareContinuation() {
        this.initContinuation();
    }

    public void reset() {
        this.cont.reset();
    }
}

