/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Link;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.common.util.StringUtils;

public class LinkHeaderProvider
implements RuntimeDelegate.HeaderDelegate<Link> {
    private static final String REL = "rel";
    private static final String TYPE = "type";
    private static final String TITLE = "title";
    private static final Set<String> KNOWN_PARAMETERS = new HashSet<String>(Arrays.asList("rel", "type", "title"));

    @Override
    public Link fromString(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Link value can not be null");
        }
        value = value.trim();
        int closeIndex = value.indexOf(62);
        if (!value.startsWith("<") || closeIndex < 2) {
            throw new IllegalArgumentException("Link URI is missing");
        }
        Link.Builder builder = new Link.Builder();
        builder.uri(value.substring(1, closeIndex).trim());
        if (closeIndex < value.length() - 1) {
            String[] tokens;
            for (String token : tokens = StringUtils.split(value.substring(closeIndex + 1), ";")) {
                String theToken = token.trim();
                if (theToken.isEmpty()) continue;
                String paramName = null;
                String paramValue = null;
                int i = token.indexOf(61);
                if (i != -1) {
                    paramName = theToken.substring(0, i).trim();
                    String string = paramValue = i == theToken.length() - 1 ? "" : theToken.substring(i + 1).trim();
                }
                if (REL.equals(paramName)) {
                    String[] rels;
                    for (String rel : rels = StringUtils.split(this.removeQuotesIfNeeded(paramValue), ",")) {
                        builder.rel(rel.trim());
                    }
                    continue;
                }
                if (TYPE.equals(paramName)) {
                    builder.type(this.removeQuotesIfNeeded(paramValue));
                    continue;
                }
                if (TITLE.equals(paramName)) {
                    builder.title(this.removeQuotesIfNeeded(paramValue));
                    continue;
                }
                builder.param(paramName, paramValue);
            }
        }
        return builder.build();
    }

    private String removeQuotesIfNeeded(String value) {
        if (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    @Override
    public String toString(Link link) {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append(link.getUri());
        sb.append('>');
        String rels = link.getRel();
        if (!rels.isEmpty()) {
            sb.append(";").append(REL).append('=');
            this.writeListParamValues(sb, rels);
        }
        if (link.getTitle() != null) {
            sb.append(";").append(TITLE).append("=\"").append(link.getTitle()).append('\"');
        }
        if (link.getType() != null) {
            sb.append(";").append(TYPE).append('=').append(link.getType());
        }
        for (Map.Entry<String, String> entry : link.getParams().entrySet()) {
            if (KNOWN_PARAMETERS.contains(entry.getKey())) continue;
            sb.append(";").append(entry.getKey()).append('=');
            this.writeListParamValues(sb, entry.getValue());
        }
        return sb.toString();
    }

    private void writeListParamValues(StringBuilder sb, String value) {
        if (StringUtils.isEmpty(value)) {
            return;
        }
        boolean commaAvailable = value.contains(",");
        if (commaAvailable) {
            sb.append('\"');
        }
        sb.append(value);
        if (commaAvailable) {
            sb.append('\"');
        }
    }
}

