/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.apache.cxf.jaxrs.impl.AbstractInterceptorContextImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class ReaderInterceptorContextImpl
extends AbstractInterceptorContextImpl
implements ReaderInterceptorContext {
    private List<ReaderInterceptor> readers;
    private InputStream is;

    public ReaderInterceptorContextImpl(Class<?> cls, Type type, Annotation[] anns, InputStream is, Message message, List<ReaderInterceptor> readers) {
        super(cls, type, anns, message);
        this.is = is;
        this.readers = readers;
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return new MetadataMap<String, String>((Map)this.m.get(Message.PROTOCOL_HEADERS), false, false, true);
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public Object proceed() throws IOException {
        if (this.readers == null || this.readers.isEmpty()) {
            return null;
        }
        ReaderInterceptor next = this.readers.remove(0);
        return next.aroundReadFrom(this);
    }

    @Override
    public void setInputStream(InputStream stream) {
        this.is = stream;
        this.m.setContent(InputStream.class, stream);
    }

    @Override
    public MediaType getMediaType() {
        return JAXRSUtils.toMediaType(this.getHeaders().getFirst("Content-Type"));
    }

    @Override
    public void setMediaType(MediaType mt) {
        if (!this.getMediaType().isCompatible(mt)) {
            this.providerSelectionPropertyChanged();
        }
        this.getHeaders().putSingle("Content-Type", JAXRSUtils.mediaTypeToString(mt, new String[0]));
    }
}

