/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.message.Message;

public class ReaderInterceptorMBR
implements ReaderInterceptor {
    private MessageBodyReader<?> reader;
    private Message m;

    public ReaderInterceptorMBR(MessageBodyReader<?> reader, Message m) {
        this.reader = reader;
        this.m = m;
    }

    public MessageBodyReader<?> getMBR() {
        return this.reader;
    }

    @Override
    public Object aroundReadFrom(ReaderInterceptorContext c) throws IOException, WebApplicationException {
        Class<?> entityCls = c.getType();
        Type entityType = c.getGenericType();
        MediaType entityMt = c.getMediaType();
        Annotation[] entityAnns = c.getAnnotations();
        if (this.m.get("provider.selection.property.changed") == Boolean.TRUE && !this.reader.isReadable(entityCls, entityType, entityAnns, entityMt)) {
            this.reader = ProviderFactory.getInstance(this.m).createMessageBodyReader(entityCls, entityType, entityAnns, entityMt, this.m);
            if (this.reader == null) {
                throw new RuntimeException("No reader available");
            }
        }
        return this.reader.readFrom(entityCls, entityType, entityAnns, entityMt, new HttpHeadersImpl(this.m).getRequestHeaders(), c.getInputStream());
    }
}

