/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class WriterInterceptorMBW
implements WriterInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(WriterInterceptorMBW.class);
    private MessageBodyWriter<Object> writer;
    private Message m;

    public WriterInterceptorMBW(MessageBodyWriter<Object> writer, Message m) {
        this.writer = writer;
        this.m = m;
    }

    public MessageBodyWriter<Object> getMBW() {
        return this.writer;
    }

    @Override
    public void aroundWriteTo(WriterInterceptorContext c) throws IOException, WebApplicationException {
        MultivaluedMap<String, Object> headers;
        Object mtObject;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Response EntityProvider is: " + this.writer.getClass().getName());
        }
        MediaType entityMt = (mtObject = (headers = c.getHeaders()).getFirst("Content-Type")) == null ? c.getMediaType() : JAXRSUtils.toMediaType(mtObject.toString());
        this.m.put("Content-Type", mtObject.toString());
        Class<?> entityCls = c.getType();
        Type entityType = c.getGenericType();
        Annotation[] entityAnns = c.getAnnotations();
        if (this.m.get("provider.selection.property.changed") == Boolean.TRUE && !this.writer.isWriteable(entityCls, entityType, entityAnns, entityMt)) {
            this.writer = ProviderFactory.getInstance(this.m).createMessageBodyWriter(entityCls, entityType, entityAnns, entityMt, this.m);
            if (this.writer == null) {
                throw new RuntimeException("No writer available");
            }
        }
        this.writer.writeTo(c.getEntity(), c.getType(), c.getGenericType(), c.getAnnotations(), entityMt, headers, c.getOutputStream());
    }
}

