/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.afm.FontMetric;
import org.apache.fontbox.cmap.CMap;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.encoding.DictionaryEncoding;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.EncodingManager;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2Font;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.util.ResourceLoader;

public abstract class PDSimpleFont
extends PDFont {
    private final HashMap<Integer, Float> mFontSizes = new HashMap(128);
    private float avgFontWidth = 0.0f;
    private float avgFontHeight = 0.0f;
    private float fontWidthOfSpace = -1.0f;
    private static final byte[] SPACE_BYTES = new byte[]{32};
    private static final Log LOG = LogFactory.getLog(PDSimpleFont.class);
    private boolean isFontSubstituted = false;

    public PDSimpleFont() {
    }

    public PDSimpleFont(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    public Font getawtFont() throws IOException {
        LOG.error("Not yet implemented:" + this.getClass().getName());
        return null;
    }

    public void drawString(String string, int[] codePoints, Graphics g, float fontSize, AffineTransform at, float x, float y) throws IOException {
        PDFont descendantFont;
        Font awtFont = this.getawtFont();
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        GlyphVector glyphs = null;
        boolean useCodepoints = codePoints != null && this.isType0Font();
        PDFont pDFont = descendantFont = useCodepoints ? ((PDType0Font)this).getDescendantFont() : null;
        if (useCodepoints && !descendantFont.getFontDescriptor().isSymbolic()) {
            PDCIDFontType2Font cid2Font = null;
            if (descendantFont instanceof PDCIDFontType2Font) {
                cid2Font = (PDCIDFontType2Font)descendantFont;
            }
            glyphs = cid2Font != null && cid2Font.hasCIDToGIDMap() || this.isFontSubstituted ? awtFont.createGlyphVector(frc, string) : awtFont.createGlyphVector(frc, codePoints);
        } else {
            if (!this.isType1Font() && awtFont.canDisplayUpTo(string) != -1) {
                LOG.warn("Changing font on <" + string + "> from <" + awtFont.getName() + "> to the default font");
                awtFont = Font.decode(null).deriveFont(1.0f);
            }
            glyphs = awtFont.createGlyphVector(frc, string);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.writeFont(g2d, at, x, y, glyphs);
    }

    public float getFontHeight(byte[] c, int offset, int length) throws IOException {
        if (this.avgFontHeight > 0.0f) {
            return this.avgFontHeight;
        }
        float retval = 0.0f;
        FontMetric metric = this.getAFM();
        if (metric != null) {
            int code = this.getCodeFromArray(c, offset, length);
            Encoding encoding = this.getFontEncoding();
            String characterName = encoding.getName(code);
            retval = metric.getCharacterHeight(characterName);
        } else {
            PDFontDescriptor desc = this.getFontDescriptor();
            if (desc != null) {
                PDRectangle fontBBox = desc.getFontBoundingBox();
                if (fontBBox != null) {
                    retval = fontBBox.getHeight() / 2.0f;
                }
                if (retval == 0.0f) {
                    retval = desc.getCapHeight();
                }
                if (retval == 0.0f) {
                    retval = desc.getAscent();
                }
                if (retval == 0.0f && (retval = desc.getXHeight()) > 0.0f) {
                    retval -= desc.getDescent();
                }
                this.avgFontHeight = retval;
            }
        }
        return retval;
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        int code = this.getCodeFromArray(c, offset, length);
        Float fontWidth = this.mFontSizes.get(code);
        if (fontWidth == null) {
            fontWidth = Float.valueOf(this.getFontWidth(code));
            if (fontWidth.floatValue() <= 0.0f) {
                fontWidth = Float.valueOf(this.getFontWidthFromAFMFile(code));
            }
            this.mFontSizes.put(code, fontWidth);
        }
        return fontWidth.floatValue();
    }

    public float getAverageFontWidth() throws IOException {
        float average = 0.0f;
        if (this.avgFontWidth != 0.0f) {
            average = this.avgFontWidth;
        } else {
            float totalWidth = 0.0f;
            float characterCount = 0.0f;
            COSArray widths = (COSArray)this.font.getDictionaryObject(COSName.WIDTHS);
            if (widths != null) {
                for (int i = 0; i < widths.size(); ++i) {
                    COSNumber fontWidth = (COSNumber)widths.getObject(i);
                    if (!(fontWidth.floatValue() > 0.0f)) continue;
                    totalWidth += fontWidth.floatValue();
                    characterCount += 1.0f;
                }
            }
            average = totalWidth > 0.0f ? totalWidth / characterCount : this.getAverageFontWidthFromAFMFile();
            this.avgFontWidth = average;
        }
        return average;
    }

    public COSBase getToUnicode() {
        return this.font.getDictionaryObject(COSName.TO_UNICODE);
    }

    public void setToUnicode(COSBase unicode) {
        this.font.setItem(COSName.TO_UNICODE, unicode);
    }

    public PDRectangle getFontBoundingBox() throws IOException {
        return this.getFontDescriptor().getFontBoundingBox();
    }

    protected void writeFont(Graphics2D g2d, AffineTransform at, float x, float y, GlyphVector glyphs) {
        if (!at.isIdentity()) {
            try {
                AffineTransform atInv = at.createInverse();
                g2d.transform(at);
                Point2D.Float newXy = new Point2D.Float(x, y);
                atInv.transform(new Point2D.Float(x, y), newXy);
                g2d.drawGlyphVector(glyphs, (float)newXy.getX(), (float)newXy.getY());
                g2d.transform(atInv);
            }
            catch (NoninvertibleTransformException e) {
                LOG.error("Error in " + this.getClass().getName() + ".writeFont", e);
            }
        } else {
            g2d.drawGlyphVector(glyphs, x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void determineEncoding() {
        String cmapName = null;
        COSName encodingName = null;
        COSBase encoding = this.getEncoding();
        Encoding fontEncoding = null;
        if (encoding != null) {
            if (encoding instanceof COSName) {
                if (this.cmap == null) {
                    encodingName = (COSName)encoding;
                    this.cmap = (CMap)cmapObjects.get(encodingName.getName());
                    if (this.cmap == null) {
                        cmapName = encodingName.getName();
                    }
                }
                if (this.cmap == null && cmapName != null) {
                    try {
                        fontEncoding = EncodingManager.INSTANCE.getEncoding(encodingName);
                    }
                    catch (IOException exception) {
                        LOG.debug("Debug: Could not find encoding for " + encodingName);
                    }
                }
            } else if (encoding instanceof COSStream) {
                if (this.cmap == null) {
                    COSStream encodingStream = (COSStream)encoding;
                    try {
                        this.cmap = this.parseCmap(null, encodingStream.getUnfilteredStream());
                    }
                    catch (IOException exception) {
                        LOG.error("Error: Could not parse the embedded CMAP");
                    }
                }
            } else if (encoding instanceof COSDictionary) {
                try {
                    fontEncoding = new DictionaryEncoding((COSDictionary)encoding);
                }
                catch (IOException exception) {
                    LOG.error("Error: Could not create the DictionaryEncoding");
                }
            }
        }
        this.setFontEncoding(fontEncoding);
        this.extractToUnicodeEncoding();
        if (this.cmap == null && cmapName != null) {
            InputStream cmapStream;
            block23: {
                cmapStream = null;
                try {
                    cmapStream = ResourceLoader.loadResource("org/apache/pdfbox/resources/cmap/" + cmapName);
                    if (cmapStream != null) {
                        this.cmap = this.parseCmap("org/apache/pdfbox/resources/cmap/", cmapStream);
                        if (this.cmap == null && encodingName == null) {
                            LOG.error("Error: Could not parse predefined CMAP file for '" + cmapName + "'");
                        }
                        break block23;
                    }
                    LOG.debug("Debug: '" + cmapName + "' isn't a predefined map, most likely it's embedded in the pdf itself.");
                }
                catch (IOException exception) {
                    try {
                        LOG.error("Error: Could not find predefined CMAP file for '" + cmapName + "'");
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(cmapStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(cmapStream);
                }
            }
            IOUtils.closeQuietly(cmapStream);
        }
    }

    private void extractToUnicodeEncoding() {
        COSName encodingName = null;
        String cmapName = null;
        COSBase toUnicode = this.getToUnicode();
        if (toUnicode != null) {
            this.setHasToUnicode(true);
            if (toUnicode instanceof COSStream) {
                try {
                    this.toUnicodeCmap = this.parseCmap("org/apache/pdfbox/resources/cmap/", ((COSStream)toUnicode).getUnfilteredStream());
                }
                catch (IOException exception) {
                    LOG.error("Error: Could not load embedded ToUnicode CMap");
                }
            } else if (toUnicode instanceof COSName) {
                encodingName = (COSName)toUnicode;
                this.toUnicodeCmap = (CMap)cmapObjects.get(encodingName.getName());
                if (this.toUnicodeCmap == null) {
                    cmapName = encodingName.getName();
                    String resourceName = "org/apache/pdfbox/resources/cmap/" + cmapName;
                    try {
                        this.toUnicodeCmap = this.parseCmap("org/apache/pdfbox/resources/cmap/", ResourceLoader.loadResource(resourceName));
                    }
                    catch (IOException exception) {
                        LOG.error("Error: Could not find predefined ToUnicode CMap file for '" + cmapName + "'");
                    }
                    if (this.toUnicodeCmap == null) {
                        LOG.error("Error: Could not parse predefined ToUnicode CMap file for '" + cmapName + "'");
                    }
                }
            }
        }
    }

    protected boolean isFontSubstituted() {
        return this.isFontSubstituted;
    }

    protected void setIsFontSubstituted(boolean isSubstituted) {
        this.isFontSubstituted = isSubstituted;
    }

    public float getSpaceWidth() {
        if (this.fontWidthOfSpace == -1.0f) {
            COSBase toUnicode = this.getToUnicode();
            try {
                if (toUnicode != null) {
                    int spaceMapping = this.toUnicodeCmap.getSpaceMapping();
                    if (spaceMapping > -1) {
                        this.fontWidthOfSpace = this.getFontWidth(spaceMapping);
                    }
                } else {
                    this.fontWidthOfSpace = this.getFontWidth(SPACE_BYTES, 0, 1);
                }
                if (this.fontWidthOfSpace <= 0.0f) {
                    this.fontWidthOfSpace = this.getAverageFontWidth();
                }
            }
            catch (Exception e) {
                LOG.error("Can't determine the width of the space character using 250 as default", e);
                this.fontWidthOfSpace = 250.0f;
            }
        }
        return this.fontWidthOfSpace;
    }
}

